#pragma once
#include "mof/widget/WidgetView.hpp"
#include <mof/widget/Layout.hpp>
#include "mof/FactoryMethod.hpp"
#include "mof/graphics/utilities.hpp"
#include "mof/tstring.hpp"
#include <memory>



namespace mof
{
    class Font;

namespace widget
{

    class Container
    : 
        public WidgetView
    {
    public:
        
        Container
        (
            const std::shared_ptr<WidgetView>& front ,
            const std::shared_ptr<WidgetView>& back ,
            const FactoryMethod<Layout>& layout
        );
    	virtual ~Container( );

        virtual FrameNumber show( bool imidiately = false );
        virtual FrameNumber hide( bool imidiately = false );
        virtual FrameNumber focus( bool imidiately = false );
        virtual FrameNumber blur( bool imidiately = false );
        virtual FrameNumber click( bool imidiately = false );
        virtual void update( );
        virtual void draw( ) const;
        virtual void setVisible(bool visible);
		virtual mof::Vector2D getPreferredSize() const;
        std::shared_ptr<WidgetView> getAt(int index) const;
        int getLength() const;
        int getAdjacencyAsUp(int index) const;
        int getAdjacencyAsDown(int index) const;
        int getAdjacencyAsLeft(int index) const;
        int getAdjacencyAsRight(int index) const;
        void add(std::shared_ptr<WidgetView> pView);

    private:
        struct Impl;
		std::unique_ptr<Impl> m_pImpl;
	
    };

}
}
