#pragma once
#include <mof/widget/HorizontalClipping.hpp>
#include <mof/ConsoleIO.hpp>

 
namespace mof
{
namespace widget
{
//{{{ constructor
	HorizontalClipping::HorizontalClipping
	(
		const mof::Manipulator<mof::Vector2D>::Handler& parentSize, 
		float initialChildSize, 
		float border
	)
		: parentSize_(parentSize), initialChildSize_(initialChildSize), border_(border), initialParentSize_(parentSize->value(0).x)
	{
	}
//}}}
//{{{ destructor
	HorizontalClipping::~HorizontalClipping() {}
//}}}
//{{{ value
	mof::Vector2D HorizontalClipping::value(mof::FrameNumber fn) const
	{
		float currentParentSize = parentSize_->value(fn).x;
		float d = border_ + (currentParentSize - initialParentSize_);
		if (d > 0) return mof::Vector2D(initialChildSize_, 0.0f);
		return initialChildSize_ + d < 0 ? mof::Vector2D(0, 0) : mof::Vector2D(initialChildSize_ + d, 0.0f);
	}
//}}}
}// namespace widget
}// namespace mof
