#pragma once

#include "mof/Vector2D.hpp"
#include "mof/Rectangle.hpp"

namespace mof
{
namespace widget
{
    class WidgetView;

    class Layout
    {

	public:
		virtual ~Layout(){}
		virtual void add(std::shared_ptr<WidgetView> pView) = 0;
        virtual Vector2D getPreferredSize() const = 0;
        virtual void connect( WidgetView* pParentView) = 0;
		virtual size_t getLength() const = 0;
        virtual int getAdjacencyAsUp(int index) const = 0;
        virtual int getAdjacencyAsDown(int index) const = 0;
        virtual int getAdjacencyAsLeft(int index) const = 0;
        virtual int getAdjacencyAsRight(int index) const = 0;
	};
}
}
