#pragma once
#include <mof/widget/Widget.hpp>
#include <boost/function/function0.hpp>
#include <mof/FactoryMethod.hpp>
#include <mof/widget/Layout.hpp>
#include <memory>

namespace mof
{
namespace widget
{

    inline void emptyFunc(){}

    struct MenuItem
    {
        mof::FactoryMethod<WidgetView> view;
        boost::function0<void> action;
        
        MenuItem
        (
            const mof::FactoryMethod<WidgetView>& view_ ,
            const boost::function0<void>& action_
        )
        : view(view_) , action(action_)
        {
        }
        
        MenuItem
        (
            const mof::FactoryMethod<WidgetView>& view_ 
        )
        : view(view_) , action(emptyFunc)
        {
        }

    };

	class Menu  : public Widget
    {
	public:
		Menu(const MenuItem& front , const MenuItem& back );
		Menu
        (
            const MenuItem& front ,
            const MenuItem& back ,
            const FactoryMethod<Layout>& layout
        );

		virtual ~Menu();
		virtual FrameNumber show(bool imidiately = false);
		virtual FrameNumber hide(bool imidiately = false);
        virtual const std::shared_ptr<WidgetView> getView( ) const;
        virtual std::shared_ptr<WidgetView> getView( );
		virtual void update();
        
        virtual FrameNumber up();
		virtual FrameNumber down();
		virtual FrameNumber left();
		virtual FrameNumber right();
		virtual FrameNumber performAction() const;
		int getSelectedIndex() const;
		std::shared_ptr<WidgetView> getSelectedView() const;
    protected:
        struct Impl;
		std::unique_ptr<Impl> m_pImpl;
	};

}
} // namespace mof 
