#   依存外部ライブラリの設定
# 
# - 新たな依存ライブラリを追加するには？
# 	標準でfind_packageできるものと，自分でFindXXX.cmakeファイルを用意しなければならないものがある．標準で備わっているかどうかは，
#
# 	http://www.cmake.org/cmake/help/cmake-2-8-docs.html
#
# 	を参照すればわかる．
#

# use Boost Library
find_package(Boost COMPONENTS filesystem thread)
if (Boost_FOUND)
	message(STATUS "Found the Boost Library:")
	message(STATUS "	include directories=${Boost_INCLUDE_DIR}")
	message(STATUS "	library directories=${Boost_LIBRARY_DIRS}")
	include_directories(${Boost_INCLUDE_DIR})
	link_libraries(${Boost_LIBRARIES})
else ()
	message(FATAL_ERROR "Could not find Boost Library.")
endif ()
