#include <mof/math/matrix3.hpp>
#include <mof/math/vector3.hpp>
#include <iostream>
#include <sstream>

int main()
{
	using namespace mof::math;
	using namespace std;
	int failed_count = 0;

	{
		matrix3 M(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		bool failed = false;
		for (size_t i = 0; i < 12; ++i) {
			if (M[i / 4][i % 4] != i + 1) failed = true;
		}
		if (failed || M[3][0] != 0 || M[3][1] != 0 || M[3][2] != 0 || M[3][3] != 1) {
			cerr << "Failed:" << " initialize test" << endl;	
			failed_count++;
		}
	}

	{
		float arr[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
		matrix3 M(arr);
		bool failed = false;
		for (size_t i = 0; i < 12; ++i) {
			if (M[i / 4][i % 4] != i + 1) failed = true;
		}
		if (failed || M[3][0] != 0 || M[3][1] != 0 || M[3][2] != 0 || M[3][3] != 1) {
			cerr << "Failed:" << " initialize by array test" << endl;	
			failed_count++;
		}
	}

	{	
		matrix3 M(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		matrix3 N(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		if (M != N) {
			cerr << "Failed:" << " M == N test" << endl;	
			failed_count++;
		}
	}
	
	{	
		matrix3 M(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		matrix3 N(0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		if (M == N) {
			cerr << "Failed:" << " M != N test" << endl;	
			failed_count++;
		}
	}

	{
		matrix3 N1(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		matrix3 N2(29, 27, 25, 23, 21, 19, 17, 15, 13, 11, 9, 7);
		matrix3 N = N1 + N2;
		matrix3 A(30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19);
		if (N != A) {
			cerr << "Failed:" << " addition test" << endl;	
			failed_count++;
		}
	}
	
	{
		matrix3 N1(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		matrix3 N2(29, 27, 25, 23, 21, 19, 17, 15, 13, 11, 9, 7);
		matrix3 N = N1 - N2;
		matrix3 A
		(
			-28, -25, -22, -19,
			-16, -13, -10,  -7,
			 -4,  -1,   2,   5
		);
		if (N != A) {
			cerr << "Failed:" << " subtraction test" << endl;	
			failed_count++;
		}
	}

	{
		matrix3 N1(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		matrix3 N2(2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13);
		matrix3 N = N1 * N2;
		matrix3 A(44, 50, 56, 66, 116, 134, 152, 178, 188, 218, 248, 290);
		if (N != A) {
			cerr << "Failed:" << "Affine matrix N1 * N2 test" << endl;	
			failed_count++;
		}
	}
	
	{
		matrix3 M(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		vector3 v(1, 2, 3);
		vector3 w = M * v;
		vector3 a(18, 46, 74);
		if (a != w) {
			cerr << "Failed:" << "M * v test" << endl;	
			failed_count++;
		}
	}


	{
		matrix3 M(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		matrix3 N = 2 * M * 3;
		matrix3 A(6, 12, 18, 24, 30, 36, 42, 48, 54, 60, 66, 72);
		if (N != A) {
			cerr << "Failed:" << "s * M * s test" << endl;	
			failed_count++;
		}
	}
	
	{
		matrix3 M(6, 12, 18, 24, 30, 36, 42, 48, 54, 60, 66, 72);
		matrix3 N = M / 6;
		matrix3 A(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
		if (N != A) {
			cerr << "Failed:" << "M / s test" << endl;	
			failed_count++;
		}
	}

	return failed_count;
}
