#include <mof/util/multimedia_timer.hpp>
#include <ctime>

namespace mof
{
namespace util
{
//{{{ impl
    struct multimedia_timer::impl
    {
        timespec prevTime_;
    };
//}}}
//{{{ constructor
    multimedia_timer::multimedia_timer()
    : pimpl_(new impl)
    {
        reset();
    }
//}}}
//{{{ destructor
    multimedia_timer::~multimedia_timer(){}
//}}}
//{{{ reset
    void multimedia_timer::reset()
    {
        clock_gettime(CLOCK_REALTIME, &pimpl_->prevTime_ );    
    }
//}}}
//{{{ get_time_in_micro_sec
    int multimedia_timer::get_time_in_micro_sec() const
    {
        timespec ts;
        clock_gettime(CLOCK_REALTIME, &ts);    
        int between = (ts.tv_nsec - pimpl_->prevTime_.tv_nsec) / 1000;
        if(ts.tv_sec != pimpl_->prevTime_.tv_sec)
        {
            between += (ts.tv_sec - pimpl_->prevTime_.tv_sec) * 1e6;
        }
        return between;

    }
//}}}

}// namespace util
}// namespace mof
