#pragma once
#include <mof/script/Environment.hpp>
#include <mof/script/ObjectData.hpp>
#include <mof/Graphics3D.hpp>
#include <memory>
	

namespace script
{

	class MyEnvironment : public mof::script::Environment
	{
	public:
		
		MyEnvironment(std::shared_ptr<mof::InputReceiver> input);
		virtual ~MyEnvironment();


	protected:	
		virtual std::unique_ptr<mof::script::MessageData> 
		create_message_data
		(
			const mof::tstring& title, const mof::script::GameData::entry_t& style
		);

		virtual std::unique_ptr<mof::script::MenuData> 
		create_menu_data
		(
			const mof::tstring& title, const std::vector<mof::tstring>& items, const mof::script::GameData::entry_t& style
		);

		virtual mof::script::GameData::ptr get_game_data(const mof::tstring& resource_path);
		
		virtual void set_game_data(const mof::tstring& resource_path, const mof::script::GameData::ptr& game_data);

		virtual std::shared_ptr<mof::Graphics3D> create_solid(const mof::tstring& class_path);
		
		virtual mof::frame_t put_element
		(
			mof::script::CommandSet::ElementType type,
			int x,
			int y
		);

		virtual int land_region_create(int x, int y);

		virtual void world_sleep();

	private:
		struct Impl;
		std::unique_ptr<Impl> impl_;
	};

}

