#pragma once
#include "world/Area.hpp"
#include <memory>
#include <mof/multi_solid.hpp>
#include <mof/stream/ReferenceWrapper.hpp>


class WorldMapBuilder
{
	AreaMap map_;
	float scale_;
protected:
	mof::tstring make_model_name(AreaPowerLevel level) const;

public:

	struct world_data_t
	{
		typedef std::shared_ptr<world_data_t> ptr;
		std::shared_ptr<mof::multi_solid> world_; 
		std::vector<mof::ReferenceWrapper<mof::Color4f>> color_refs_;
		size_t width_;
		size_t height_;

		world_data_t() : width_(0), height_(0) {}
	};

	WorldMapBuilder(const AreaMap &map, float scale);
	virtual ~WorldMapBuilder(void);
	AreaMap get_map() const {return map_;} 
	std::unique_ptr<world_data_t> create() const;
};

