require('script/strict')
require('script/priority')
--[eBeB֐
--{{{ is_empty
function is_empty(str)
	if str == nil or str == '' then return true
	else return false end
end
--}}}
--{{{ split
function split(str, delim)
	if string.find(str, delim) == nil then
		return str
	end

	local result = {}
	local pat = '(.-)' .. delim .. '()'
	local last_pos
	for part, pos in string.gfind(str, pat) do
		table.insert(result, part)
		last_pos = pos
	end
	table.insert(result, string.sub(str, last_pos))
	return unpack(result)
end
--}}}
--{{{ join
function join(tbl, sep)
	local ret
	for n, v in pairs(tbl) do
		local seg = tostring(v)
		if ret == nil then
			ret = seg
		else
			ret = ret .. sep .. seg
		end
	end
	return ret
end
--}}}
--{{{ find
function find(tbl, elem)
	if tbl == nil then return false end

	for n, v in ipairs(tbl) do
		if v == elem then return n end
	end
	return false
end
--}}}
--{{{ layout
function layout(left_margin, width, right_margin, top_margin, height, bottom_margin)
	-- TODO get from app
	local data = load_game_data('system.client_region')
	local screen_width = data[1]['width'] 
	local screen_height = data[1]['height']

	local x, y --results

	-- TODO parameter check. use error function
	if left_margin ~= nil and right_margin ~= nil then
		-- Ẽ}[W璆Sʒu߂
		local center_from_left = left_margin + (1.0 - left_margin - right_margin) / 2
		x = center_from_left * screen_width - width / 2
	end
	
	if top_margin ~= nil and bottom_margin ~= nil then
		-- ㉺̃}[W璆Sʒu߂
		local center_from_top = top_margin + (1.0 - top_margin - bottom_margin) / 2
		y = center_from_top * screen_height - height / 2
	end
	return x, y;
end
--}}}
--{{{ to_client_coord
function to_client_coord(left_margin, top_margin, width, height)
	-- TODO get from app
	local data = load_game_data('system.client_region')
	local screen_width = data[1]['width'] 
	local screen_height = data[1]['height']

	local x = left_margin * screen_width
	local y = top_margin * screen_height

	if width ~= nil and height ~= nil then
		local w = width * screen_width
		local h = height * screen_height
		return x, y, w, h
	else 
		return x, y
	end
			
end
--}}}
--moflib API
--{{{ waitFrame
function wait_frame(frame)
	waitFrameImpl(frame)
	coroutine.yield()
end

--̃L[萔InputReceiverƓĂȂ΂ȂȂ
KEY_UP    = 1
KEY_DOWN  = 2
KEY_LEFT  = 3
KEY_RIGHT  = 4
KEY_A      = 5
KEY_B      = 6
KEY_C      = 7
KEY_D      = 8
KEY_E      = 9
KEY_F      = 10
KEY_G      = 11
KEY_H      = 12
KEY_I      = 13
KEY_J      = 14
KEY_K      = 15
KEY_L      = 16
KEY_M      = 17
KEY_N      = 18
KEY_O      = 19
KEY_P      = 20
KEY_Q      = 21
KEY_R      = 22
KEY_S      = 23
KEY_T      = 24
KEY_U      = 25
KEY_V      = 26
KEY_W      = 27
KEY_X      = 28
KEY_Y      = 29
KEY_Z      = 30
KEY_ESCAPE = 31 
KEY_ANY    = 32
--}}}
--{{{ quit
function quit()
	mof_quit()
	coroutine.yield()
end

--̃L[萔InputReceiverƓĂȂ΂ȂȂ
KEY_UP    = 1
KEY_DOWN  = 2
KEY_LEFT  = 3
KEY_RIGHT  = 4
KEY_A      = 5
KEY_B      = 6
KEY_C      = 7
KEY_D      = 8
KEY_E      = 9
KEY_F      = 10
KEY_G      = 11
KEY_H      = 12
KEY_I      = 13
KEY_J      = 14
KEY_K      = 15
KEY_L      = 16
KEY_M      = 17
KEY_N      = 18
KEY_O      = 19
KEY_P      = 20
KEY_Q      = 21
KEY_R      = 22
KEY_S      = 23
KEY_T      = 24
KEY_U      = 25
KEY_V      = 26
KEY_W      = 27
KEY_X      = 28
KEY_Y      = 29
KEY_Z      = 30
KEY_ESCAPE = 31 
KEY_ANY    = 32
--}}}
--{{{ sound
function sound(filepath)
	local obj = Sound:new(filepath)
	obj:play()
	obj:dispose()
end
--{{{ new
Sound = {}
function Sound:new(filepath)
	local id = soundCreateImpl(filepath)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Sound})
	return obj
end
--}}}
--{{{ set_tween
function Sound:set_tween(target, stream)
	objectSetBehaviorImpl(self.id_, 'sound.' .. target, stream, 0)
end
--}}}
--{{{ play
function Sound:play()
	mof_sound_play(self.id_)
end
--}}}
--{{{ dispose
function Sound:dispose()
	disposeImpl(self.id_, 'sound')
end
--}}}
--}}}
--{{{ music
--{{{ new
Music = {}
function Music:new(filepath)
	local id = musicCreateImpl(filepath)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Music})
	return obj
end
--}}}
--{{{ set_tween
function Music:set_tween(target, stream)
	objectSetBehaviorImpl(self.id_, 'music.' .. target, stream, 0)
end
--}}}
--{{{ play
function Music:play()
	mof_music_play(self.id_)
end
--}}}
--{{{ pause
function Music:pause()
	mof_music_pause(self.id_)
end
--}}}
--{{{ dispose
function Music:dispose()
	disposeImpl(self.id_, 'music')
end
--}}}
--}}}
--{{{ load_game_data
function load_game_data(resource_path)
	return loadGameDataImpl(resource_path)
end
--}}}
--{{{ save_game_data
function save_game_data(resource_path, data)
	return mof_save_game_data(resource_path, data)
end
--}}}
--{{{ wait_for_key
function wait_for_key(key)
	waitForKeyImpl(key)
	coroutine.yield()
end
--}}}
--{{{ get_last_key
function get_last_key()
	return getLastKeyImpl()
end
--}}}
--{{{ get_key
function get_key()
	wait_for_key(KEY_ANY)
	return get_last_key()
end
--}}}
--{{{ message
function message(title, texts, priority, style, initializer)
	local obj = Message:new(title, style, priority)
	if initializer ~= nil then initializer(obj) end
	local frame = obj:show()
	--wait_frame(frame)
	for i = 1 , #texts , 1  
	do
		local frame = obj:next(texts[i])
		wait_frame(frame)
		wait_for_key(KEY_Z)
	end 
	local frame = obj:hide()
	wait_frame(frame)
	obj:dispose()
end
--{{{ new
Message = {}
function Message:new(title, style, priority)
	if style == nil then style = '' end
	local id = messageNewImpl(title, style, priority)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Message})
	return obj
end
--}}}
--{{{ show
function Message:show()
	return showImpl(self.id_, 'message')
end
--}}}
--{{{ hide
function Message:hide()
	return hideImpl(self.id_, 'message')
end
--}}}
--{{{ set_tween
function Message:set_tween(target, stream, period)
	if period == nil then period = 0 end
	objectSetBehaviorImpl(self.id_, 'message.' .. target, stream, period)
end
--}}}
--{{{ get_property
function Message:get_properties()
	return objectGetPropertiesImpl(self.id_, 'message')
end
--}}}
--{{{ next
function Message:next(text)
	print_debug(text)
	return messageNextImpl(self.id_, text)
end
--}}}
--{{{ typename
function Message:typename()
	return 'message'
end
--}}}
--{{{ enable
function Message:enable(is_enable)
	return mof_obj_enable(self.id_, is_enable, 'message')
end
--}}}
--{{{ dispose
function Message:dispose(text)
	return disposeImpl(self.id_, 'message')
end
--}}}
--}}}
--{{{ text
function text(title, text, priority, style, initializer)
	local obj = Message:new(title, style, priority)
	if initializer ~= nil then initializer(obj) end
	obj:show()
	local frame = obj:next(text)
	return obj
end
--}}} text
--{{{ question
function question(title, items, priority, style, initializer, ignore_cancel, callback_move_cursor, callback_select)
	if ignore_cancel == nil then ignore_cancel = false end
	local disables = {}
	if not is_empty(style) then 
		-- IvV
		local s = {split(style, ';')}
		for idx, ss in ipairs(s) do 
			local n, v = split(ss, '=')
			if n == 'disable' then
				disables = {split(v, ',')}
				break
			end
		end
	end
	local obj = Question:new(title, items, priority, style)
	if initializer ~= nil then initializer(obj) end
	local frame = obj:show()
	wait_frame(frame)
	while true do
		local old_index = obj:get_current()
		local key = get_key()

		if key == KEY_UP then obj:move_cursor_up()
		elseif key == KEY_DOWN then obj:move_cursor_down()
		elseif key == KEY_LEFT then obj:move_cursor_left()
		elseif key == KEY_RIGHT then obj:move_cursor_right()
		elseif key == KEY_X and ignore_cancel == false then 
			sound("sound/cancel.wav")-- LZ
			frame = obj:hide()
			wait_frame(frame)
			obj:dispose()
			return 0 --LZ
		elseif key == KEY_Z then 
			if not find(disables, tostring(old_index)) then -- disableȂ疳
				sound("sound/decide.wav")-- 艹
				frame = obj:select()
				wait_frame(frame)
				local continue = true
				if callback_select ~= nil then continue = callback_select(old_index) end
				if continue then
					frame = obj:hide()
					wait_frame(frame)
					obj:dispose()
					return old_index + 1 --0 ̓LZ̓
				end
			end
		end	
		local index = obj:get_current()
		if index ~= old_index and callback_move_cursor ~= nil then callback_move_cursor(index) end
	end
end
--{{{ new
Question = {}
function Question:new(title, items, priority, style)
	print_debug(title)
	if style == nil then style = '' end
	local id = menuNewImpl(title, items, style, priority)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Question})
	return obj
end
--}}}
--{{{ show
function Question:show()
	return showImpl(self.id_, 'menu')
end
--}}}
--{{{ hide
function Question:hide()
	return hideImpl(self.id_, 'menu')
end
--}}}
--{{{ set_tween
function Question:set_tween(target, stream, period)
	if period == nil then period = 0 end
	objectSetBehaviorImpl(self.id_, 'menu.' .. target, stream, period)
end
--}}}
--{{{ get_property
function Question:get_properties()
	return objectGetPropertiesImpl(self.id_, 'menu')
end
--}}}
--{{{ move_cursor
MOVE_UP    = 0
MOVE_DOWN  = 1
MOVE_LEFT  = 2
MOVE_RIGHT = 3

function Question:move_cursor_up()
	return menuMoveCursorImpl(self.id_, MOVE_UP)
end

function Question:move_cursor_down()
	return menuMoveCursorImpl(self.id_, MOVE_DOWN)
end

function Question:move_cursor_left()
	return menuMoveCursorImpl(self.id_, MOVE_LEFT)
end

function Question:move_cursor_right()
	return menuMoveCursorImpl(self.id_, MOVE_RIGHT)
end
--}}}
--{{{ get_currnet
function Question:get_current()
	return menuGetCurrentImpl(self.id_)
end
--}}}
--{{{ select
function Question:select()
	return menuSelectImpl(self.id_)
end
--}}}
--{{{ typename
function Question:typename()
	return 'question'
end
--}}}
--{{{ enable
function Question:enable(is_enable)
	return mof_obj_enable(self.id_, is_enable, 'menu')
end
--}}}
--{{{ dispose
function Question:dispose()
	return disposeImpl(self.id_, 'menu')
end
--}}}
--}}}
--{{{ print_debug
function print_debug(obj, spacer)
	if (type(obj) ~= 'table') then
		mof_print_debug(tostring(obj))
		return
	end

	if spacer == nil then spacer = '' end

	for key, value in pairs(obj) do  
		if (type(value) ~= 'table') then
			mof_print_debug(spacer .. tostring(key) .. ' => ' .. tostring(value))
		else
			mof_print_debug(spacer .. tostring(key) .. ' => ' )
			print_debug(value, spacer .. '  ')
		end
	end
end
--}}}
--{{{ picture
--{{{ new
Picture = {}
function Picture:new(path, priority)
	local id = pictureCreateImpl(path, priority)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Picture})
	return obj
end
--}}}
--{{{ set_tween
function Picture:set_tween(target, stream)
	objectSetBehaviorImpl(self.id_, 'picture.' .. target, stream, 0)
end
--}}}
--{{{ get_properties
function Picture:get_properties()
	return objectGetPropertiesImpl(self.id_, 'picture')
end
--}}}
--{{{ typename
function Picture:typename()
	return 'picture'
end
--}}}
--{{{ enable
function Picture:enable(is_enable)
	return mof_obj_enable(self.id_, is_enable, 'picture')
end
--}}}
--{{{ dispose
function Picture:dispose()
	return disposeImpl(self.id_, 'picture')
end
--}}}
--}}}
--{{{ board
--{{{ new
Board = {}
function Board:new(path, priority, style)
	if style == nil then style = '' end
	local id = mof_board_create(path, priority, style)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Board})
	return obj
end
--}}}
--{{{ set_tween
function Board:set_tween(target, stream)
	objectSetBehaviorImpl(self.id_, 'board.' .. target, stream, 0)
end
--}}}
--{{{ typename
function Board:typename()
	return 'board'
end
--}}}
--{{{ enable
function Board:enable(is_enable)
	return mof_obj_enable(self.id_, is_enable, 'board')
end
--}}}
--{{{ dispose
function Board:dispose()
	return disposeImpl(self.id_, 'board')
end
--}}}
--}}}
--{{{ camera
--{{{ new
Camera = {}
function Camera:new()
	local id = mof_camera_create()
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Camera})
	return obj
end
--}}}
--{{{ set_tween
function Camera:set_tween(target, stream)
	objectSetBehaviorImpl(self.id_, 'camera.' .. target, stream, 0)
end
--}}}
--{{{ get_property
function Camera:get_properties()
	return objectGetPropertiesImpl(self.id_, 'camera')
end
--}}}
--}}}
--{{{ particlegen
--{{{ new
Particlegen = {}
function Particlegen:new()
	local id = particlegenCreateImpl()
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Particlegen})
	return obj
end
--}}}
--{{{ set_tween
function Particlegen:set_tween(target, stream)
	objectSetBehaviorImpl(self.id_, 'particlegen.' .. target, stream, 0)
end
--}}}
--{{{ typename
function Particlegen:typename()
	return 'particlegen'
end
--}}}
--{{{ enable
function Particlegen:enable(is_enable)
	return mof_obj_enable(self.id_, is_enable, 'particlegen')
end
--}}}
--{{{ dispose
function Particlegen:dispose()
	return disposeImpl(self.id_, 'particlegen')
end
--}}}
--}}}
--{{{ solid
--{{{ new
Solid = {}
function Solid:new(class_path, priority)
	local id = solidCreateImpl(class_path, priority)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Solid})
	return obj
end
--}}}
--{{{ set_tween
function Solid:set_tween(target, stream)
	objectSetBehaviorImpl(self.id_, 'solid.' .. target, stream, 0)
end
--}}}
--{{{ set_light
function Solid:set_light(light_id)
	mof_set_light(self.id_, light_id.id_)
end
--}}}
--{{{ typename
function Solid:typename()
	return 'solid'
end
--}}}
--{{{ enable
function Solid:enable(is_enable)
	return mof_obj_enable(self.id_, is_enable, 'solid')
end
--}}}
--{{{ dispose
function Solid:dispose()
	return disposeImpl(self.id_, 'solid')
end
--}}}
--}}}
--{{{ invoke
Routine = {}
ThreadTable = {} -- Ӑ}ȂKx[WRNVh߂̃e[u
function invoke(func, ...)
	local co = coroutine.create(function (id, ...) 
		coroutine.yield()-- nĂyield
		func(...)
		-- CɏIʒm
		mof_routine_stop(id)
		table.remove(ThreadTable, id)
	end)
	local thread_id = mof_invoke(co)
	coroutine.resume(co, thread_id, ...)
	local obj = {}
	obj.id_ = thread_id
	ThreadTable[thread_id] = co -- Ӑ}ȂKxR΍
	setmetatable(obj, {__index = Routine})
	return obj
end

function Routine:stop()
	mof_routine_stop(self.id_)
	table.remove(ThreadTable, self.id_)
end	

--}}}
--{{{ put_element
function put_element(element_type, x, y)
	return mof_put_element(element_type, x, y) 
end
--}}}
--{{{ world_sleep
function world_sleep()
	return mof_world_sleep() 
end
--}}}
--{{{ land_region_create
LandRegion = {}
function land_region_create(x, y, priority)
	local id = mof_land_region_create(x, y, priority) 
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = LandRegion})
	return obj
end
--{{{ typename
function LandRegion:typename()
	return 'land_region'
end
--}}}
--{{{ dispose
function LandRegion:dispose()
	return disposeImpl(self.id_, 'vertex_buffer')
end
--}}}
--}}}
--{{{ joint
function joint(target1, joint_type, target2)
	if target1:typename() == 'solid' and target2:typename() == 'solid' then
		mof_solid_joints_solid(target1.id_, joint_type, target2.id_)
	elseif target1:typename() == 'board' and target2:typename() == 'solid' then
		mof_board_joints_solid(target1.id_, joint_type, target2.id_)
	end
	print_debug('invalid joint')
	print_debug(target1:typename())
	print_debug(target2:typename())
end
--}}}
--{{{ light
--{{{ new
Light = {}
function Light:new(class_path)
	local id = mof_light_create(class_path)
	local obj = {}
	obj.id_ = id
	setmetatable(obj, {__index = Light})
	return obj
end
--}}}
--{{{ set_tween
function Light:set_tween(target, stream)
	objectSetBehaviorImpl(self.id_, 'light.' .. target, stream, 0)
end
--}}}
--{{{ dispose
function Light:dispose()
	return disposeImpl(self.id_, 'light')
end
--}}}
--}}}
