require('script/moflib')
require('script/common')
require('script/stage_menu')
require('script/main_menu')
require('script/land_menu')
require('script/effect')

--{{{ title_question
function title_question(title, items, priority, style, initializer, ignore_cancel, callback_move_cursor, callback_select)
	if ignore_cancel == nil then ignore_cancel = false end
	local disables = {}
	if not is_empty(style) then 
		-- IvV
		local s = {split(style, ';')}
		for idx, ss in ipairs(s) do 
			local n, v = split(ss, '=')
			if n == 'disable' then
				disables = {split(v, ',')}
				break
			end
		end
	end
	local obj = Question:new(title, items, priority, style)
	if initializer ~= nil then initializer(obj) end
	local frame = obj:show()
	wait_frame(frame)
	while true do
		local old_index = obj:get_current()
		local key = get_key()

		if key == KEY_UP then obj:move_cursor_up()
		elseif key == KEY_DOWN then obj:move_cursor_down()
		elseif key == KEY_LEFT then obj:move_cursor_left()
		elseif key == KEY_RIGHT then obj:move_cursor_right()
		elseif key == KEY_X and ignore_cancel == false then 
			sound("sound/cancel.wav")-- LZ
			frame = obj:hide()
			wait_frame(frame)
			obj:dispose()
			return 0 --LZ
		elseif key == KEY_Z then 
			if not find(disables, tostring(old_index)) then -- disableȂ疳
				sound("sound/warp.wav")-- 艹
				frame = obj:select()
				wait_frame(frame)
				local continue = true
				if callback_select ~= nil then continue = callback_select(old_index) end
				if continue then
					-- EBhEƂ̏
					
					-- Ó]
					invoke(transition, 100, 100, PRIORITY_TITLE_SCENE_TRANSITION)
					wait_frame( 100 )
					obj:dispose()
					return old_index + 1 --0 ̓LZ̓
				end
			end
		end	
		local index = obj:get_current()
		if index ~= old_index and callback_move_cursor ~= nil then callback_move_cursor(index) end
	end
end
--}}}
--{{{ make_land_scale_level
function make_land_scale_level( land_scale )
	if land_scale > 9 then
		return 2
	elseif land_scale > 4 then
		return 1
	else
		return 0
	end
end
--}}}
--{{{ area_menu
function area_menu(world)
	local cursor_x = 0
	local cursor_y = 0

	local s = Solid:new('file.model/area_cursor.x', PRIORITY_WORLD_SCENE_CURSOR)
	joint(s, 'distance', world)-- J[\̓[h̓ɒǏ]
	
	local area_info = text('', ' ', PRIORITY_WORLD_SCENE_MENU, 'view=no-title-bg', FeedTween:new(0.05, 0.05, 0.70, 0.15))

	local area = load_game_data('gamedata.area_profile.' .. cursor_x .. '.' .. cursor_y)
	local area_pic = update_area(s, cursor_x, cursor_y, area_info, area[1], nil)
	wait_frame(30)
	local region = nil-- h݂ꍇ̂land region\
	if area[1].land_flag == '1' then 
		region = land_region_create(cursor_x, cursor_y, PRIORITY_WORLD_SCENE_LAND_REGION)
	end

	while true do
		local skip = false
		local k = get_key()
		if k == KEY_X then 
			sound('sound/cancel.wav')
			break
		elseif k == KEY_Z then 
			sound('sound/decide.wav')
			if area[1].forest_flag == '1' then 
				forest_already_located()
			elseif area[1].earth_flag == '1' then 
				earth_already_located()
			elseif area[1].water_flag == '1' then 
				water_already_located()
			elseif area[1].capital_flag == '1' then 
				enter_land(area[1], cursor_x, cursor_y)
			else 
				element_menu(area[1], cursor_x, cursor_y, s)
				area = load_game_data('gamedata.area_profile.' .. cursor_x .. '.' .. cursor_y)-- GAXV
			end
			skip = true
		elseif k == KEY_UP    and cursor_y > 0  then cursor_y = cursor_y - 1 
		elseif k == KEY_DOWN  and cursor_y < 5 then cursor_y = cursor_y + 1 
		elseif k == KEY_LEFT  and cursor_x > 0  then cursor_x = cursor_x - 1 
		elseif k == KEY_RIGHT and cursor_x < 5 then cursor_x = cursor_x + 1 
		else skip = true end

		if not skip then
			sound('sound/select.wav')
			area = load_game_data('gamedata.area_profile.' .. cursor_x .. '.' .. cursor_y)
			area_pic = update_area(s, cursor_x, cursor_y, area_info, area[1], area_pic)
			if region then 
				region:dispose() 
				region = nil
			end
			if area[1].land_flag == '1' then region = land_region_create(cursor_x, cursor_y, PRIORITY_WORLD_SCENE_LAND_REGION) end
		end
	end
	s:dispose()
	area_info:dispose()
	area_pic:dispose()
	if region then region:dispose() end
end
--}}}
--{{{ title
function title()
	-- wĩZbgAbv
	local size = load_game_data('system.client_region')[1]
	local bg = Picture:new('file.image/fill.png', PRIORITY_TITLE_SCENE_BACKGROUND)
	bg:set_tween('position2', {[0] = {0, 0}})
	bg:set_tween('size2', {[0] = {size.width, size.height}})
	bg:set_tween('color', {[0] = {0.1, 0.1, 0.1}})
	
	-- tB^̃ZbgAbv	
	local size = load_game_data('system.client_region')[1]
	local filter = Picture:new('file.image/fill.png', PRIORITY_TITLE_SCENE_FILTER)
	filter:set_tween('position2', {[0] = {0, 0}})
	filter:set_tween('size2', {[0] = {size.width, size.height}})
	filter:set_tween('color', {[0] = {1, 0, 0, 0}, [100] = {1, 0, 0, 0}, [130] = {0, 0 , 0, 0}})

	-- S̕\
	local logos = {}
	title1( logos )

	wait_frame(30)

	-- TODO volume
	local bgm = Music:new('music/ClosedPage.ogg')
	bgm:play()

	wait_frame(60)

	local world_routine = invoke(show_world_consecutively)
	
	wait_frame(30)

	local answer = title2()

	if answer == 3 then
		-- exit game
		quit()
	end

	-- n
	world_routine:stop()
	filter:dispose()
	bg:dispose()
	bgm:dispose()
	for i, v in pairs(logos)
	do
		v:dispose()
	end

	-- 1 Ȃ New Game
	-- 2 Ȃ Continue
	-- 3 Ȃ Exit
	return answer

	end
--}}}
--{{{ title1
function title1(logos)

	local positions = { 
		{0, 0}, -- 
		{100, 38}, -- 
		{183, 0}, -- 
		{270, 25}, -- T
		{365, 5}, -- N
		{450, 0}, -- V
		{525, 8}, -- [
		{610, 20}, -- h
	}

	local visible = {1, 1, 1, 1}
	local invisible = {0, 1, 1, 1}
	local span = 3
	for i = 1, 8
	do
		local logo = Picture:new('file.image/title/logo' .. i .. '.png', PRIORITY_TITLE_SCENE_LOGO)
		logo:set_tween('position2', {[0] = {positions[i][1] -15, positions[i][2]}})
		logo:set_tween('color', 
			{
				[0] = invisible, [i * span] = invisible, [i * span + 1] = visible, 
				[(i + 1) * span] = visible, [(i + 1) * span + 1] = invisible,
				[50] = invisible, [51] = visible
			})
		table.insert(logos, logo)
	end


end
--}}}
--{{{ title2
function title2()

	local items = {
		'<layout w="130" h="28" xalign="center" yalign="center">New Game</layout>',
		'<layout w="130" h="28" xalign="center" yalign="center"><col name="gray">Continue</col></layout>',
		'<layout w="130" h="28" xalign="center" yalign="center">Exit</layout>',
	}

	local answer = 0
	local handler = function (index)
		if index == 0 then
			-- new game
			return true
		elseif index == 1 then
			-- continue
			return false
		elseif index == 2 then
			-- exit
			return true
		end
		return false
	end

	answer = title_question('', items, PRIORITY_TITLE_SCENE_MENU, 'disable=1', ExtensionTween:new(), true, nil, handler )

	-- 1 Ȃ New Game
	-- 2 Ȃ Continue
	-- 3 Ȃ Exit
	return answer
end
--}}}
--{{{ show_world_consecutively
function show_world_consecutively()
	while true do
		local routine = invoke(show_world)
		wait_frame(1500)
		invoke(transition, 100, 100, PRIORITY_TITLE_SCENE_FILTER)
		wait_frame(100)
		routine:stop() -- show_world ͏IȂ̂ŖIstop
	end
end
--}}} 
--{{{ show_world
function show_world()
	local camera = Camera:new()
	camera:set_tween('eye', {[0] = {0, 1.4, -1.8}})
	camera:set_tween('lookat', {[0] = {0, 0, 0}})

	local s = Solid:new('world', PRIORITY_TITLE_SCENE_WORLD)
	local earth = Solid:new('file.model/world.x', PRIORITY_TITLE_SCENE_WORLD)
	joint(earth, 'distance', s)

	s:set_tween('rotate3', {['loop'] = {0, 7000}, [0] = {0, 0, 0}, [7000] = {0, 6.28, 0}})
	local world_light = Light:new('directional')
	world_light:set_tween('position3', 
		{
			['loop'] = {0, 2400},
			[0] = {1, -0.1, 0},
			[600] = {0, -0.1, -1},
			[1200] = {-1, -0.1, 0},
			[1800] = {0, -0.1, -1},
			[2400] = {1, -0.1, 0},
		})
	world_light:set_tween('ambient.color', {[0] = {0.5, 0.5, 0.9}})
	world_light:set_tween('diffuse.color', {[0] = {1, 1, 1}})
	s:set_light(world_light)

	local land_names = {}
	local land_icons = {}

	for i = 0, 5 do
		for j = 0, 5 do
			local area = load_game_data('gamedata.area_profile.' .. i .. '.' .. j)
			if area[1].capital_flag == '1' then
				local name = area[1].name
				name = '<col code="000011"><font name="Vinque" size="22" edge="1"><layout w="50" xalign="center">' .. name .. '</layout></font></col>'
				local land_scale_level = make_land_scale_level( tonumber(area[1].land_scale) );
	
				-- h
				local b = Board:new(name, PRIORITY_WORLD_SCENE_LAND_NAME, 'z-buffer=disable')
				b:set_tween('position3', {[0] = {0.2 * i - 0.5, 0.1, -0.2 * j + 0.5}})
				b:set_tween('size3', {[0] = {1.4, 1.4, 1.4}})
				joint(b, 'distance', s)
				table.insert(land_names, b)
				
				-- hACR 
				local icon = Board:new('file.image/land_icon.png', PRIORITY_WORLD_SCENE_LAND_NAME -1, 'z-buffer=disable')
				icon:set_tween('position3', {[0] = {0.2 * i - 0.5, 0.01, -0.2 * j + 0.5}})
				icon:set_tween('size3', {[0] = {0.2, 0.2, 0.2}})

				local u = land_scale_level % 4; 
				local v = math.floor(land_scale_level / 4); 
				icon:set_tween('texcoord', {[0] = { u * 0.25, v * 0.25, (u + 1) * 0.25, (v + 1) * 0.25}})
				joint(icon, 'distance', s)
				table.insert(land_icons, icon)
			end
		end
	end


	while true do	
		wait_frame(1000)
	end
end
function show_world_()
	local camera = Camera:new()
	camera:set_tween('eye', {[0] = {0, 1.4, -1.8}})
	camera:set_tween('lookat', {[0] = {0, 0, 0}})

	local s = Solid:new('world', PRIORITY_TITLE_SCENE_WORLD)
	local earth = Solid:new('file.model/world.x', PRIORITY_TITLE_SCENE_WORLD)
	joint(earth, 'distance', s)

	s:set_tween('rotate3', {['loop'] = {0, 7000}, [0] = {0, 0, 0}, [7000] = {0, 6.28, 0}})
	local world_light = Light:new('directional')
	world_light:set_tween('position3', 
		{
			['loop'] = {0, 2400},
			[0] = {1, -0.1, 0},
			[600] = {0, -0.1, -1},
			[1200] = {-1, -0.1, 0},
			[1800] = {0, -0.1, -1},
			[2400] = {1, -0.1, 0},
		})
	world_light:set_tween('ambient.color', {[0] = {0.5, 0.5, 0.9}})
	world_light:set_tween('diffuse.color', {[0] = {1, 1, 1}})
	s:set_light(world_light)
	
	local land_names = {}
	local land_icons = {}

	for i = 0, 5 do
		for j = 0, 5 do
			local area = load_game_data('gamedata.area_profile.' .. i .. '.' .. j)
			if area[1].capital_flag == '1' then
				local name = area[1].name
				name = '<col code="000011"><font name="Vinque" size="22" edge="1"><layout w="50" xalign="center">' .. name .. '</layout></font></col>'
				local land_scale_level = make_land_scale_level( tonumber(area[1].land_scale) );
	
				-- h
				local b = Board:new(name, PRIORITY_WORLD_SCENE_LAND_NAME, 'z-buffer=disable')
				b:set_tween('position3', {[0] = {0.2 * i - 0.5, 0.1, -0.2 * j + 0.5}})
				b:set_tween('size3', {[0] = {1.4, 1.4, 1.4}})
				joint(b, 'distance', s)
				table.insert(land_names, b)
				
				-- hACR 
				local icon = Board:new('file.image/land_icon.png', PRIORITY_WORLD_SCENE_LAND_NAME -1, 'z-buffer=disable')
				icon:set_tween('position3', {[0] = {0.2 * i - 0.5, 0.01, -0.2 * j + 0.5}})
				icon:set_tween('size3', {[0] = {0.2, 0.2, 0.2}})

				local u = land_scale_level % 4; 
				local v = math.floor(land_scale_level / 4); 
				icon:set_tween('texcoord', {[0] = { u * 0.25, v * 0.25, (u + 1) * 0.25, (v + 1) * 0.25}})
				joint(icon, 'distance', s)
				table.insert(land_icons, icon)
			end
		end
	end

	-- vO{̂disposeĂ΂
	while true do	
		wait_frame(1000)
	end
end
--}}}
