#include "mof/Captor.hpp"
#include "mof/private/GraphicsDeviceImpl.hpp"
#include "mof/FilePath.hpp"
#include "mof/ConsoleIO.hpp"
#include <sstream>


mof::Captor::Captor(const mof::tstring& output)
: m_output(output) 
{
	m_num = 0;
}

mof::Captor::~Captor(){

}

bool mof::Captor::capture(){
	mof::otstringstream os;
	os << m_output.c_str() << _T("/") << m_num << _T(".jpg");
	return capture(os.str().c_str());
}



bool mof::Captor::capture(const mof::tstring& filename){
	
	LPDIRECT3DDEVICE9 pDevice = mof::GraphicsDevice::getRawDevice();
	
	LPDIRECT3DSURFACE9 pBackBuffer;
	HRESULT hr = pDevice->GetBackBuffer(0 , 0 , D3DBACKBUFFER_TYPE_MONO , &pBackBuffer);
	if(FAILED(hr))throw std::runtime_error("Failed --- GetBackBuffer");
	D3DSURFACE_DESC desc;
	pBackBuffer->GetDesc(&desc);

	hr = D3DXSaveSurfaceToFile(
		filename.c_str() , D3DXIFF_JPG , pBackBuffer ,
		NULL , NULL);
	pBackBuffer->Release();
	if(FAILED(hr)){
		
		throw std::runtime_error("Failed -- D3DXSaveSurfaceToFile");
	}
	m_num++;
	return true;
	

}
