
#ifndef CONSOLE_H
#define CONSOLE_H

#include <iostream>
#include <windows.h>
#include <tchar.h>

//--------------------------------------------
// class ConsoleIO
//
// R\[ĂяoAo͂sB
// C++̓o̓Xg[NXAstd::basic_stream
// pB
//--------------------------------------------
template <class CharT , class Tr = std::char_traits<CharT> >
class ConsoleIO : public std::basic_streambuf<CharT , Tr>{

protected:
    std::streampos seekoff( 
        std::streamoff off, 
        std::ios::seek_dir dir, 
        int nMode = std::ios::in | std::ios::out ){
        return EOF;
    	}
    
    std::streampos seekpos( std::streampos , int   ){
        return EOF;
    }

    int_type overflow( int_type nCh = EOF ){
        DWORD size;
	WriteConsole(GetStdHandle(STD_OUTPUT_HANDLE),(WCHAR*)&nCh,1,&size,NULL);
        return 0;
    	}

    int_type underflow(void){
        return EOF;
    }


public:
    ConsoleIO(){
        setbuf(0,0);
        AllocConsole();
    	}
	
    ~ConsoleIO(){
        FreeConsole();
    	}

};



//--------------------------------------------
// class ConsoleOut
//
// R\[o͂ɂ́ÃNX̃IuWFNg
//--------------------------------------------
class ConsoleOut : public std::basic_iostream<TCHAR> {
    static ConsoleOut* obj;
	
	ConsoleOut(void) 
        : std::basic_iostream<TCHAR>(new ConsoleIO<TCHAR>() ){
    }

public:
	static ConsoleOut* getInstance(){
		if(obj == NULL)obj = new ConsoleOut();
		return obj;
	}


};

#define DEBUG_PRINT(x) (*ConsoleOut::getInstance() << x << std::endl)
//#define DEBUG_PRINT(x)

#endif 
