#include <memory>
#include <boost/weak_ptr.hpp>
#include "mof/EventScheduler.hpp"

namespace mof{
	
	template <class T>
	class Deleter{
		std::shared_ptr<T> m_p;
	public:
		Deleter(T* p) : m_p(p) {}
		Deleter( typename std::shared_ptr<T>& p) : m_p(p) {}

		void operator ()(){
			m_p = std::shared_ptr<T>();
		}

		boost::weak_ptr<T> getWeak(){
			return m_p;
		}
	};

};
