#include "mof/LoggingInputReceiver.hpp"
#include "mof/InputDevice.hpp"
#include <fstream>


mof::LoggingInputReceiver::LoggingInputReceiver(TCHAR* filename )
: m_filename(filename){
}

mof::LoggingInputReceiver::~LoggingInputReceiver(){
	output();
}

bool mof::LoggingInputReceiver::testKeyState(mof::InputReceiver::Key key){
	bool result = mof::InputDevice::getInputReceiver()->testKeyState(key);
	m_log.push_back(result);
	return result;
	
}

void mof::LoggingInputReceiver::update(){
	mof::InputDevice::getInputReceiver()->update();
}



void mof::LoggingInputReceiver::output(){
	std::ofstream ofs( m_filename.c_str() );
	for(std::list<bool>::iterator itr = m_log.begin() ; itr != m_log.end() ; ++itr){
		ofs << *itr << std::endl;
	}

}