#include "mof/OnceEventCondition.hpp"
#include "mof/utilities.hpp"

namespace mof
{
    OnceEventCondition::OnceEventCondition( EventCondition* pBody )
    : m_disposable( false ) , m_pBody( pBody )
    {
    }

    OnceEventCondition::~OnceEventCondition( )
    {
        mof::safe_delete( m_pBody );
    }

    bool OnceEventCondition::test( )
    {
        bool result = m_pBody->test();
        if( !m_disposable && result )m_disposable = true;
        return result;
    }

    void OnceEventCondition::update( )
    {
        m_pBody->update();
    }

    bool OnceEventCondition::isDisposable( )
    {
        return m_disposable;
    }



}

