#pragma once
#include "mof/tstring.hpp"
#include <map>
#include <list>
#include <memory>
#include "mof/ConsoleIO.hpp"

namespace mof{
	
	

	/** \[X̃v[Ax[h@\񋟂ev[g
	 *
	 *
	*/
	template <class T >
	class ResourceManager
	{
		typedef std::list<std::shared_ptr<ResourceManager<T > > > MANAGER_LIST;
		typedef std::map<mof::tstring , std::shared_ptr<T>> RESOURCE_MAP;
		

        ResourceManager<T>* m_pParent;
		RESOURCE_MAP m_resources;
		MANAGER_LIST m_children;
	
		static std::shared_ptr<T> nullPtr;
		//void addResouce(Resouce* pResource);
	public:
		typedef std::shared_ptr<ResourceManager<T>> ptr;
		ResourceManager();
		virtual ~ResourceManager(void);

		std::shared_ptr<T> getResource(const tstring& name );
		void addResource(const TCHAR * const name , std::shared_ptr<T>& resource);
        std::shared_ptr< ResourceManager<T> > createChild();
	};



	template <class T>
	std::shared_ptr<T> ResourceManager<T>::nullPtr = std::shared_ptr<T>();



	/** eȂƂăIuWFNg
	 *
	 */
	template <class T >
	ResourceManager<T >::ResourceManager( ){
		m_pParent = NULL;
	}

	/** g̃\[XƎqAe̎qXg玩g폜
	 */
	template <class T  >
	ResourceManager<T >::~ResourceManager(){
		//g̊Ǘ郊\[XA[h
        m_resources.clear();

		//qIuWFNg폜
        m_children.clear();
			
		//e玩g폜
		if(m_pParent != NULL){
			for(MANAGER_LIST::iterator itr = m_pParent->m_children.begin() ; itr != m_pParent->m_children.end() ; ++itr){
				if(this == itr->get() ){
					m_pParent->m_children.erase(itr);
					return;
				}
			}
		}
	}

	

	/** VȎqǉAԂ
	 * @return q
	 */
	template <class T  >
	std::shared_ptr< ResourceManager<T> > ResourceManager<T >::createChild(){
        std::shared_ptr< ResourceManager<T > > manager(new ResourceManager<T>( ));
		manager->m_pParent = this;
		m_children.push_back(manager);
		return manager;
	}

	
	/** ؍\Ŝw肳ꂽÕ\[XE擾<br>
	 * Ȃ΁AɐVɐB
	 * @param name \[X
	 * @param parameter \[X쐬̈iw肵ȂĂ悢j 
	 * @return vꂽ\[X
	 */
	template <class T >
	std::shared_ptr<T> ResourceManager<T >::getResource(const mof::tstring& name){
		//̃XgT
		RESOURCE_MAP::const_iterator n = m_resources.find(name);
		if (n != m_resources.end()) {
			return n->second;
			//return (std::shared_ptr<T>&)n->second;
		}
		
		//q̃XgT

		//ẽXgT

		//Ȃ΍쐬
		std::shared_ptr<T> resource( new T( name ) );
		DEBUG_PRINT(name << _T("܂") );
		m_resources.insert(RESOURCE_MAP::value_type(name , resource));
		n = m_resources.find(name);
		return n->second;
		//return (std::shared_ptr<T>&)n->second;
	}

	
	template <class T>
	void ResourceManager<T>::addResource(const TCHAR* const name , std::shared_ptr<T>& resource){
		m_resources.insert(RESOURCE_MAP::value_type(mof::tstring(name) , resource));
	}


	/*template <class T , typename K >
	std::shared_ptr<T>& ResourceManager<T , K>::findResource(mof::tstring& name , K parameter){

	}*/


};
