#pragma once
#include "mof/Color.hpp"
#include "mof/Vector2D.hpp"
#include "mof/Vector3D.hpp"
namespace mof{


struct VertexXYZRHWCUV{
	float x , y , z , rhw;
	mof::Color color;
	float tu , tv;	

	VertexXYZRHWCUV(){
	}

	VertexXYZRHWCUV(const mof::Vector2D& position , mof::Color color , float tu , float tv){
		x = static_cast<float>(position.x);
		y = static_cast<float>(position.y);
		z = 0.0f;
		rhw = 1.0f;
		this->color = color;
		this->tu = tu;
		this->tv = tv;
	}
};

struct VertexXYZRHWC{
	float x , y , z , rhw;
	mof::Color color;

	VertexXYZRHWC(){
	}

	VertexXYZRHWC(const mof::Vector2D& position , mof::Color color){
		x = static_cast<float>(position.x);
		y = static_cast<float>(position.y);
		z = 0.0f;
		rhw = 1.0f;
		this->color = color;
	}
};


struct VertexXYZCUV{
	float x , y , z;
	mof::Color color;
	float tu , tv;

	VertexXYZCUV(){
	}

	VertexXYZCUV(const mof::Vector3D& position , mof::Color color ,float tu , float tv){
		x = position.x;
		y = position.y;
		z = position.z;
		this->color = color;
		this->tu = tu;
		this->tv = tv;
	}
};

struct VertexXYZNUV{
	float x , y , z;
	float nx , ny , nz;
	float tu , tv;

	VertexXYZNUV(){
	}

	VertexXYZNUV(const mof::Vector3D& position , const mof::Vector3D& normal , float tu , float tv){
		x = position.x;
		y = position.y;
		z = position.z;
		nx = normal.x;	
		ny = normal.y;
		nz = normal.z;
		this->tu = tu;
		this->tv = tv;
	}
};

struct VertexXYZC{
	float x , y , z;
	mof::Color color;

	VertexXYZC(){
	}

	VertexXYZC(const mof::Vector3D& position , const mof::Color _color){
		x = position.x;
		y = position.y;
		z = position.z;
		color = _color;
	}
};

enum PRIMITIVE_TYPE{
	PRIMITIVE_TYPE_TRIANGLESTRIP,
	PRIMITIVE_TYPE_TRIANGLELIST ,
	PRIMITIVE_TYPE_LINELIST
};


}
