
#include <mof/private/FileTextureBuilder.hpp>
#include <d3dx9.h>
#include <DxErr.h>
#include <mof/private/GraphicsDeviceImpl.hpp>
#include "mof/ConsoleIO.hpp"

mof::FileTextureBuilder::FileTextureBuilder( const mof::tstring& path)
{
	m_path = path;
	
}

mof::FileTextureBuilder::~FileTextureBuilder(void)
{
}


LPDIRECT3DTEXTURE9 mof::FileTextureBuilder::create(){
	LPDIRECT3DTEXTURE9 texture;
	LPDIRECT3DDEVICE9 pDevice = mof::GraphicsDevice::getRawDevice();
	HRESULT hr = D3DXCreateTextureFromFileEx(pDevice , m_path.c_str() , 
			0 , 0 , 1 , 0/*RENDER*/ , D3DFMT_UNKNOWN , D3DPOOL_MANAGED ,
			D3DX_DEFAULT , D3DX_DEFAULT , mof::createColor(0 , 0 , 0) , NULL , NULL , &texture);

	if(FAILED(hr))throw std::runtime_error("Failed --- CreateTextureFromFileEx");
		
	return texture;	

	

}