#pragma once
#include <memory>
#include <mof/tstring.hpp>

namespace mof
{
namespace script
{
	class CommandSet;

	class LuaInterpreter
	{
	public:
		LuaInterpreter(const std::shared_ptr<CommandSet>& commands, const mof::tstring& filename);
		virtual ~LuaInterpreter();
		virtual void start(const mof::tstring& entry_function);
		virtual void update(const std::shared_ptr<CommandSet>& commands);
	private:
		struct Impl;
		std::unique_ptr<Impl> impl_;	
	};

}// namespace script
}// namespace mof
