#pragma once
#include "mof/Vector2D.hpp"
#include "mof/stream/Manipulator.hpp"


namespace mof{

    class Filter : public Manipulator< Vector2D >
    {
    public:
        typedef std::shared_ptr<Filter> Handler;
	
        Filter
        (
		    const Manipulator<Vector2D>::Handler& body ,
            const mof::Vector2D& filter
		)
        : m_body( body ) , m_filter( filter)
 	    {
 	    }

	    virtual Vector2D value( FrameNumber frame ) const
        {
            mof::Vector2D value = m_body->value(frame);
		    return mof::Vector2D( value.x * m_filter.x , value.y * m_filter.y);
	    }


    private:
 	    Manipulator< Vector2D >::Handler  m_body;
 	    Vector2D m_filter;


    };

//{{{ ヘルパ関数
    inline Filter::Handler makeFilterHandler
    (
 	    const Manipulator< Vector2D >::Handler&  body ,
        const Vector2D& filter
    )
	{
        return Filter::Handler
            (
                new Filter( body , filter  )
            );
   	}
//}}}

} // namespace mof

