#pragma once
#include <memory>
#include <boost/utility.hpp>
#include <memory>
#include "mof/tstring.hpp"
#include <mof/stream/Manipulator.hpp>
#include <mof/Vector2D.hpp>
#include <mof/Color.hpp>
#include <mof/widget/WidgetView.hpp>

namespace mof
{
	class Board;

namespace widget
{
    struct Page;

    class AbstractTextCompiler : boost::noncopyable
    {
    public:
		enum BehaviorTarget
		{
			PAGE_OPEN,
			PAGE_CLOSE,
		};

        virtual ~AbstractTextCompiler(){}
		virtual std::auto_ptr<mof::widget::WidgetView> compile_to_widget(const mof::tstring& text) = 0; // {compile
		virtual std::shared_ptr<mof::Board> compile_to_board(const mof::tstring& text) = 0; 
		virtual void setBehaviorOnPosition(BehaviorTarget target, mof::Manipulator<mof::Vector2D>::Handler position, FrameNumber period) = 0;
		virtual void setBehaviorOnColor(BehaviorTarget target, mof::Manipulator<mof::Color4f>::Handler color, FrameNumber period) = 0;

    };//class AbstractTextCompiler

}// namespace widget
}// namespace mof
