#pragma once
#include <boost/utility.hpp>
#include <boost/scoped_ptr.hpp>
#include <mof/tstring.hpp>
#include <memory>
#include <mof/widget/Frame.hpp>
#include <mof/widget/WidgetView.hpp>
#include <mof/FactoryMethod.hpp>

namespace mof
{
    class Font;
namespace widget
{

    class FrameBuilder : boost::noncopyable
    {
    public:
        FrameBuilder();
        ~FrameBuilder();

        void setTitle( const mof::tstring& title , const mof::Font& font );
        void setContentBackgroundView( const mof::FactoryMethod<WidgetView>& contentBackground );
        void setTitleBackgroundView( const mof::FactoryMethod<WidgetView>& titleBackground );
        std::auto_ptr<Frame> create( );

    private:
        struct Impl;
        boost::scoped_ptr<Impl> m_pImpl;

    }; // class FrameBuilder
} // namespace widget
} // namespace mof
