#pragma once
#include <mof/widget/WidgetView.hpp>
#include <mof/stream/Manipulator.hpp>
#include <boost/utility.hpp>
#include <memory>

namespace mof
{
namespace widget
{

	class Widget : public boost::noncopyable 
    {
	public:
		virtual ~Widget(){}
		virtual FrameNumber show(bool imidiately = false) = 0;
		virtual FrameNumber hide(bool imidiately = false) = 0;
        virtual const std::shared_ptr<WidgetView> getView() const = 0;
        virtual std::shared_ptr<WidgetView> getView() = 0;
		virtual void update() = 0;
	};

}
}
