#pragma once
#include "BattlerFacade.h"
#include "mof/DataTable.h"
#include "mof/DataRow.h"

namespace et{
	class BattleAI;
	class DataBasedBattler : public BattlerFacade
	{
		mof::DataResourceManager* m_pDataResourceManager;
		mof::DataRow m_targetRow;
		mof::DataRow m_typeRow;
		BattleAI* m_pAI;

		void updateAI(const TCHAR* const name);
	public:
		DataBasedBattler(const TCHAR* pName , mof::DataResourceManager* pDataResourceManager , mof::TextureManager* pTextureManager,  TCHAR serialCode);
		virtual ~DataBasedBattler(void);

		virtual mof::AnimationResource setMovingAnimation(mof::Vector3D& goal , int nFrame);
		virtual mof::AnimationResource setAidlingAnimation(mof::Vector3D& position);
		virtual mof::AnimationResource setCastAnimation(int category);
		virtual mof::AnimationResource setDamagedAnimation(int level);
		virtual Action* createAction(BattlerGroup* pGroup );
		mof::DataRow getDataRow(){return m_targetRow;}
		
	};

}
