#include "FixedBattler.h"
#include "mof/KeyFrameAnimation.h"
#include "AttackAction.h"
#include "SpecialAction.h"
#include "BattlerGroup.h"
#include "GameData.h"
#include "AttackAction.h"
#include "SpecialAction.h"

et::FixedBattler::FixedBattler(BattlerType type , et::BattlerParameter& parameter , mof::TextureManager* pTextureManager , et::GameData* pGameData)
: BattlerFacade(type) , m_pGameData(pGameData)
{
	m_command.type = et::BattleAction::NONE;
	setParameter(parameter);
	
	if(getType() == et::HERO){
		m_pGraphicsObject = new mof::Billboard(mof::Billboard::Y_FIXED , pTextureManager->getResource(_T("image/hero0.png")));
	}
	else if(getType() == et::ENEMY){
		m_pGraphicsObject = new mof::Billboard(mof::Billboard::Y_FIXED , pTextureManager->getResource(_T("image/hd.png")));
	}
	else if(getType() == et::IDEAL){
		m_pGraphicsObject = new mof::Billboard(mof::Billboard::Y_FIXED , pTextureManager->getResource(_T("image/ideal.png")));
	}

	mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
	pAnimation->setScale(0 , mof::Vector3D(0.3f , 0.3f , 0.3f));
	pAnimation->setTextureRectangle(0 , mof::Line2D(0 , 0 , 64 , 64));
	getGraphicsObject()->setAnimation( 0 , mof::AnimationResource(pAnimation));
	
	
}




mof::AnimationResource et::FixedBattler::setMovingAnimation(mof::Vector3D& goal , int nFrame){
	mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
	pAnimation->setPosition(0 , getPosition());
	pAnimation->setPosition(nFrame-1 , goal);
	mof::AnimationResource resource(pAnimation);
	getGraphicsObject()->setAnimation( 1 , resource);
	return resource;
}

mof::AnimationResource et::FixedBattler::setAidlingAnimation(mof::Vector3D& position ){
	if(!getParameter().alive){
		//\Ȃ
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation(true);
		pAnimation->setPosition(0 , position);
		pAnimation->setTextureRectangle(0 , mof::Line2D(1 , 1 , 1 , 1));
		mof::AnimationResource resource(pAnimation);
		getGraphicsObject()->setAnimation( 1 , resource);
		return resource;
	}
	else if(getParameter().guard && getType() == et::HERO){
		//K[h
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation(true);
		pAnimation->setPosition(0 , position);
		pAnimation->setTextureRectangle(0 , mof::Line2D(0 , 64*2 , 64 , 64*3));
		mof::AnimationResource resource(pAnimation);
		getGraphicsObject()->setAnimation( 1 , resource);
		return resource;
	}
	else {
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation(true);
		pAnimation->setPosition(0 , position);
		pAnimation->setTextureRectangle(0 , mof::Line2D(0 , 0 , 64 , 64));
		pAnimation->setTextureRectangle(15 , mof::Line2D(0 , 64 , 64 , 64*2));
		pAnimation->setTextureRectangle(30-1 , mof::Line2D(0 , 0 , 64 , 64));
		mof::AnimationResource resource(pAnimation);
		getGraphicsObject()->setAnimation( 1 , resource);
		return resource;
	}
}

mof::AnimationResource et::FixedBattler::setCastAnimation(int category){
	mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
	
	if(category == 0){
		//ʏU
		pAnimation->setPosition(0 , getPosition());
		pAnimation->setTextureRectangle(0 , mof::Line2D(64 , 0 , 128 , 64));
		pAnimation->setTextureRectangle(10 , mof::Line2D(64 , 64 , 128 , 64*2));
		pAnimation->setTextureRectangle(20 , mof::Line2D(64 , 128 , 128 , 64*3));
		pAnimation->setFinalKey(20);
	}
	else if(category == 1){
		pAnimation->setPosition(0 , getPosition());
		pAnimation->setTextureRectangle(0 , mof::Line2D(64*2 , 0 , 64*3 , 64));
		pAnimation->setTextureRectangle(40 , mof::Line2D(0 , 0 , 64 , 64));
		pAnimation->setFinalKey(20);
	}
	mof::AnimationResource resource(pAnimation);
	getGraphicsObject()->setAnimation( 1 , resource);
	return resource;
	
}

mof::AnimationResource et::FixedBattler::setDamagedAnimation(int level){
	mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
	if(level == 0){
		//ʏ
		mof::Vector3D backPosition = getPosition();
		backPosition.x += (getType() == et::ENEMY)? -0.1f : 0.1f;
		pAnimation->setPosition(0 , getPosition());
		pAnimation->setPosition(10 , backPosition);
		pAnimation->setPosition(40 , backPosition);
		pAnimation->setPosition(60 , getPosition());
	
		pAnimation->setTextureRectangle(0 , mof::Line2D(0 , 0 , 64 , 64));
		pAnimation->setTextureRectangle(8 , mof::Line2D(64*3 , 0 , 256 , 64));
		pAnimation->setTextureRectangle(10 , mof::Line2D(1 , 1 , 1 , 1));
		pAnimation->setTextureRectangle(12 , mof::Line2D(64*3 , 0 , 256 , 64));
		pAnimation->setTextureRectangle(14 , mof::Line2D(1 , 1 , 1 , 1));
		pAnimation->setTextureRectangle(16 , mof::Line2D(1 , 1 , 1 , 1));
		pAnimation->setTextureRectangle(26 , mof::Line2D(0 , 0 , 64 , 64));
		
	}
	else if(level == 1){
		//S
		
		mof::Vector3D backPosition = getPosition();
		backPosition.x += (getType() == et::ENEMY)? -0.1f : 0.1f;
		pAnimation->setPosition(0 , getPosition());
		pAnimation->setPosition(10 , backPosition);
		
		pAnimation->setTextureRectangle(0 , mof::Line2D(0 , 0 , 64 , 64));
		pAnimation->setTextureRectangle(8 , mof::Line2D(64*3 , 0 , 256 , 64));
		pAnimation->setTextureRectangle(10 , mof::Line2D(1 , 1 , 1 , 1));
		pAnimation->setTextureRectangle(12 , mof::Line2D(64*3 , 0 , 256 , 64));
		pAnimation->setTextureRectangle(14 , mof::Line2D(1 , 1 , 1 , 1));
		pAnimation->setTextureRectangle(25 , mof::Line2D(1 , 1 , 1 , 1));
		
	}
	mof::AnimationResource resource(pAnimation);
	getGraphicsObject()->setAnimation( 1 , resource);
	return resource;
}

void et::FixedBattler::setBattleCommand(BattleAction& action){
	m_command = action;
}

et::Action* et::FixedBattler::createAction(BattlerGroup* pGroup ){
	
	if(m_command.type == et::BattleAction::ATTACK_WEAPON){
		return new AttackAction(this , m_command.pTarget , 3);
	}
	else if(m_command.type == et::BattleAction::WAIT || m_command.type == et::BattleAction::GUARD){
		return NULL;
	}
	else if(m_command.type == et::BattleAction::CAST){
		et::BattlerFacade* pIdeal = pGroup->getIdealBattlerAt(m_command.idealIndex);
		et::BattlerParameter parameter = pIdeal->getParameter();
		parameter.dActionPoint -= 5;
		pIdeal->setParameter(parameter);
		std::vector<et::BattlerFacade*> targetList;
		if(m_command.pTarget != NULL)targetList.push_back(m_command.pTarget);
		else targetList = pGroup->getEnemyBattlerListAlive();
		
		//Z̎ނ𓾂
		return new SpecialAction(this , targetList , 5 , m_command.idealIndex);
	}
	else if(m_command.type == et::BattleAction::USE_ITEM){
		//ACeȂ
		std::list<et::ItemData> &refList = m_pGameData->getBattleItemList();
		for(std::list<et::ItemData>::iterator itr = refList.begin() ; itr != refList.end() ; ++itr){
			if(m_command.pTargetItem == &(*itr)){
				refList.erase(itr);
				break;
			}
		}
		std::vector<et::BattlerFacade*> targetList;
		if(m_command.pTarget != NULL)targetList.push_back(m_command.pTarget);
		else targetList = pGroup->getEnemyBattlerListAlive();

		//Z̎ނ𓾂
		return new SpecialAction(this , targetList , 2 , 3);
	}
	else return NULL;
}
/*et::Action* et::FixedBattler::createNextAction(std::list<BattlerFacade*>& enemy , std::list<BattlerFacade*>& ally){
//if(pBattler->getParameter().actionPoint >= 3)return new AttackAction(pBattler , getHeroBattler() , 3 ,  1.0f);
		//else return NULL;
	return NULL;
}*/