#include "MyInstructionSet.hpp"
//#include "mof/ImageTileWidgetView.hpp"
#include "mof/utilities.hpp"
#include "mof/LayoutManager.hpp"
#include "mof/Deleter.hpp"
#include "mof/mofInput.hpp"
#include "mof/mofGraphics.hpp"
#include <boost/bind.hpp>
#include "mof/EventScheduler.hpp"
#include <list>
#include "mof/ConsoleIO.hpp"
#include "mof/widgets.hpp"

struct MyInstructionSet::Impl
{
    std::list<boost::weak_ptr<mof::MessageWidget> > inactiveResources;
    mof::EventScheduler scheduler;
    std::list<std::shared_ptr<mof::MessageWidget> > messages;
    
    Impl()
    {
    }
    
    ~Impl()
    {
    }
    
    
};

MyInstructionSet::MyInstructionSet(  )
: m_pImpl(new Impl() )
{
}


MyInstructionSet::~MyInstructionSet( )
{
}
//{{{ createMessageWidget
std::shared_ptr<mof::MessageWidget>
MyInstructionSet::createMessageWidget( ) 
{
    mof::LayoutManager* pLayout = new mof::LayoutManager( mof::LayoutManager::HORIZONTAL , 1);
	mof::WidgetView* pBackgroundView = new mof::ImageTileWidgetView( _T("image/frame0.png")  );
	
	
	std::shared_ptr<mof::MessageWidget> p
	(
	    new mof::MessageWidget
	    (
		    pBackgroundView ,
		    mof::Rectangle<int>(70+20 , 300 , 570+20 , 450) , pLayout
		)
	);
	    
	m_pImpl->messages.push_back(p);
	return p;
	
}
//}}}
//{{{ addMessageWidgetPage
int
MyInstructionSet::addMessageWidgetPage
( 
    std::shared_ptr<mof::MessageWidget>& message , 
    const mof::tstring &title , 
    const mof::tstring &text
) 
{
	mof::PageRequest page(text , mof::Font(_T("~UISVbN") , 25) );
	message->addPage( page );
    return 30;// TODO y[WĴɂ鎞	
}
//}}}

void MyInstructionSet::inactive( std::shared_ptr<mof::MessageWidget>& message ) 
{   

	/*mof::Deleter<mof::MessageWidget> del(message);
				
	m_pImpl->inactiveResources.push_back(del.getWeak());
	m_pImpl->scheduler.addEvent( 40 , del );*/
	//m_pImpl->scheduler.addEvent( 40 , boost::bind( &mof::Interpreter::doNextCommand , this ) );
}

void MyInstructionSet::update( )
{
    m_pImpl->scheduler.update( );
    foreach(boost::weak_ptr<mof::MessageWidget>& resource , m_pImpl->inactiveResources)
	{
	    if(resource.lock())resource.lock()->update();
	}
}
  
void MyInstructionSet::draw() const
{
    foreach(std::shared_ptr<mof::MessageWidget>& resource , m_pImpl->messages )
    {
        resource->draw();
    }
    foreach(boost::weak_ptr<mof::MessageWidget>& resource , m_pImpl->inactiveResources)
	{
	    if(resource.lock())resource.lock()->draw();
	}
}

  
