#include "StageScene.h"
#include "mof/GraphicsDevice.h"
#include "mof/AmbientLight.h"
#include "mof/InputDevice.h"
#include "mof/ConsoleIO.h"
#include <math.h>
#include "mof/System.h"
#include "DungeonBuilderA.h"
#include "mof/AmbientLight.h"
#include "mof/KeyFrameAnimation.h"
#include "MapImageColor.h"
#include "mof/Sprite.h"

/*inline int roundUpCast(float f){
	if(f - (float)((int)f) > 0.0f)return (int)f + 1;
	else return (int)f;
}*/

et::StageScene::StageScene()
: et::GameScene() , m_blockWidth(16) , m_blockHeight(16)
//, m_symbolScale(mof::Matrix3D::createScaling(0.2f , 0.4f , 0.2f))
{

	m_pMiniMap = NULL;
	m_pMapBlocks = new mof::VertexBuffer<mof::VertexXYZCUV>*[m_blockWidth * m_blockHeight];
	for(int x = 0 ; x < m_blockWidth ; x++){
		for(int y = 0 ; y < m_blockHeight ; y++)m_pMapBlocks[y * m_blockWidth + x] = NULL;
	}
	m_pCamera = NULL;
	m_pSymbolManager = NULL;
	m_pInputReceiver = NULL;
	m_pMapBuilder = NULL;

	m_pHero = NULL;
	m_pHeroController = NULL;
	m_pTest = mof::Sprite::createSpriteFromText(_T("u܂́Bv") , 32);
	
}

et::StageScene::~StageScene(void)
{
	
	delete m_pMiniMap;
	for(int x = 0 ; x < m_blockWidth ; x++){
		for(int y = 0 ; y < m_blockHeight ; y++)delete m_pMapBlocks[y * m_blockWidth + x];
	}
	delete[] m_pMapBlocks;
	delete m_pCamera;
	//delete m_pHero;
	//delete m_pHeroController;
	//delete m_pInputReceiver;
	delete m_pSymbolManager;
	delete m_pMapBuilder;
	delete m_pTest;
	
}


bool et::StageScene::initialize(){
	
	//m_pInputReceiver = mof::InputDevice::getInstance()->getInputReceiver();

	mof::TextureResource pTexture( new mof::Texture(mof::tstring(_T("image/map.png"))));
	std::shared_ptr<mof::PixelMap>map = pTexture->getPixelMap();
	

	//_W}bv쐬
	m_pMapBuilder = new et::DungeonBuilderA(*(map.get()) , m_pTextureManager , 0.3f);
	m_pMapBuilder->setBlockSize(16 , 16);
	for(int x = 0 ; x < m_blockWidth ; x++){
		for(int y = 0 ; y < m_blockHeight ; y++)m_pMapBlocks[y * m_blockWidth + x] = m_pMapBuilder->createBlock(x , y);
	}
	m_pCamera = new mof::Camera(mof::Vector3D(0.0f , 0.7f*2 , -1.0f*2) , mof::Vector3D(0.0f , 0.0f , 0.0f) , mof::Vector3D(0.0f , 1.0f , 0.0f));
	m_pCamera->reflect();

	//mof::AmbientLight(mof::createColor(255 , 255 , 255)).reflect();
	mof::GraphicsDevice::getInstance()->setProjectionTransform(0.01f , 50.0f);

	m_pTexture = m_pTextureManager->getResource(_T("image/maptip0.png"));

	//V{̍쐬
	m_pSymbolManager = new et::SymbolManager(m_pTextureManager , m_pMapBuilder);
	mof::Billboard* pBillboard = new mof::Billboard(mof::Billboard::Y_FIXED , m_pTextureManager->getResource(_T("image/chara.png")));
	pBillboard->setTextureRectangle(mof::Line2D(0 , 0 ,32 , 64));
	m_pHero = new et::Symbol( pBillboard , mof::Vector3D(0.2f , 0.4f , 0.2f));
	
	//m_pHeroController = new et::RandomSymbolController();
	m_pHeroController = new et::InputSymbolController(m_pInputReceiver);
	m_pHeroController->add(m_pHero);
	m_pSymbolManager->add(m_pHeroController);

	

	//~j}bv̍쐬
	const int tWidth = pTexture->getWidth();
	const int tHeight = pTexture->getHeight();
	for(int x = 0 ; x < tWidth ; x++){
		for(int y = 0 ; y < tHeight ; y++){
			if(map->get(x , y) == mof::createColor(0 , 255 , 0)){
				//lʒuƑ傫ݒ
				mof::Vector3D position(((float)x+0.5f) * m_pMapBuilder->getScale() , 0.0f , (-(float)y+0.5f) * m_pMapBuilder->getScale());
				m_pHero->setPosition(position , et::Symbol::DOWN );//Î~
				m_pHero->update();
			}
			if(et::isWalkableColor(map->get(x , y)) ){
				mof::Color color = mof::createColor(55 , 50 , 255);
				map->set(x , y , color);
			}
			else{
				mof::Color color = mof::createColor(100 , 0 , 0 , 255);
				map->set(x , y , color);
			}
		}
	}
	pTexture = mof::TextureResource(new mof::Texture(mof::tstring(_T("")) , *(map.get())));
	m_pMiniMap = new mof::Sprite(mof::Line2D(32 , 32 , tWidth*2 +32, tHeight*2 + 32) , mof::Line2D(0 , 0 , tWidth , tHeight) , pTexture);
	
	//GV{zu
	for(int i = 0 ; i < 100 ; i++)m_pSymbolManager->create();


	return true;
}
	
bool et::StageScene::draw(){
	//m_pCapturer->capture();
	mof::GraphicsDevice* pDevice = mof::GraphicsDevice::getInstance();
	pDevice->clearRenderTarget(mof::createColor(27 , 27 , 27));//27
	pDevice->setAlphaBlendingMode(mof::GraphicsDevice::BLENDING_MODE_BASIC);
	pDevice->setZBuffer(true);
	pDevice->clearZBuffer();
	pDevice->setLight(false);

	
	m_pTexture->setTextureToDevice();
	for(int x = 0 ; x < m_blockWidth ; x++){
		for(int y = 0 ; y < m_blockHeight ; y++){
			//KvȃubN̂ݕ`悷(Direct3D̃NbsOɔC)
			
			//if(x == blockPos.x && y == blockPos.y)
			m_pMapBlocks[y * m_blockWidth + x]->draw(mof::Matrix3D());
		}
	}
	
	
	m_pSymbolManager->draw();
	m_pMiniMap->draw();

	//V{ʒu|Cg̕`
	std::vector<et::Symbol*>* pList = m_pSymbolManager->getSymbolList();
	for(int i = 0 ; i < pList->size() ; i++){
		mof::Vector3D pos3D = pList->at(i)->getPosition();
		mof::Vector2D pos2D(pos3D.x / m_pMapBuilder->getScale() , -pos3D.z / m_pMapBuilder->getScale());
		pos2D.x  = 32 + pos2D.x * 2;
		pos2D.y  = 32 + pos2D.y * 2;
		mof::Sprite point(mof::Line2D(pos2D.x , pos2D.y , pos2D.x + 2 , pos2D.y + 2),
			mof::Line2D(0 , 0 , 1 , 1) , m_pTextureManager->getResource(_T("null")));
		if(pList->at(i) != m_pHero)point.setCornerColor(mof::createColor(255 , 0 , 0));
		point.draw();
	}

	m_pTest->draw();
	return true;
}


bool et::StageScene::update(){
	
	m_pSymbolManager->update();

	std::vector<et::Symbol*> touchedList = m_pSymbolManager->testCollision(m_pHero);
	m_pTest->setPosition(mof::Vector2D(650 , 50));
	for(int i = 0 ; i < touchedList.size() ; i++){
		if(touchedList.at(i) == m_pHero)continue;
		//퓬˓`
		m_pTest->setPosition(mof::Vector2D(400 , 50));
	}
	
	m_pCamera->setWorldTransform(mof::Matrix3D::createTranslation(m_pHero->getPosition()));//lV{̈ʒuJ̈ʒu
	m_pCamera->reflect();
	
	mof::Billboard::updateBillboardDirection(m_pCamera);


	return true;
}


