#pragma once
#include "GameScene.h"
#include "mof/TextureResource.h"
#include "mof/Camera.h"
#include "mof/VertexBuffer.h"
#include "mof/VertexTypes.h"
#include "mof/Billboard.h"
#include "SymbolManager.h"
#include "mof/InputReceiver.h"
#include "DungeonBuilder.h"

#include "mof/Capturer.h"
#include "InputSymbolController.h"
#include "RandomSymbolController.h"

namespace et{

	class StageScene
		: public et::GameScene
	{
		mof::Sprite* m_pMiniMap;
		mof::VertexBuffer<mof::VertexXYZCUV>** m_pMapBlocks;
		const int m_blockWidth , m_blockHeight;
		mof::Camera* m_pCamera;
		mof::TextureResource m_pTexture;
		SymbolManager* m_pSymbolManager;
		et::DungeonBuilder* m_pMapBuilder;

		Symbol* m_pHero;
		et::SymbolController* m_pHeroController;
		
		//mof::InputReceiver* m_pInputReceiver;
		mof::Sprite* m_pTest;
	public:
		StageScene();
		virtual ~StageScene(void);

		

		virtual bool initialize();
		virtual bool draw();
		virtual bool update();
	

	};

};
