#include "SymbolManager.h"
#include "MapImageColor.h"
#include "mof/Billboard.h"
#include "RandomSymbolController.h"
#include <math.h>

et::SymbolManager::SymbolManager(mof::TextureManager* pTextureManager , et::DungeonBuilder* pMapBuilder)
{
	m_pTextureManager = pTextureManager;
	m_pMapBuilder = pMapBuilder;
}

et::SymbolManager::~SymbolManager(void)
{
	for(int i = 0 ; i < m_symbols.size() ; i++)delete m_symbols.at(i);
	for(int i = 0 ; i < m_controllers.size() ; i++)delete m_controllers.at(i);
}

void et::SymbolManager::update(){
	for(int i = 0 ; i < m_controllers.size() ; i++)m_controllers.at(i)->update();//ړAjݒ
	for(int i = 0 ; i < m_symbols.size() ; i++){
		et::Symbol* pSymbol = m_symbols.at(i);
		mof::Vector3D prePos3D = pSymbol->getPosition();
		pSymbol->update();//ŎۂɈړ

		mof::Vector3D pos3D = pSymbol->getPosition();
		//S_œ蔻
		float tableX[] = { -pSymbol->getScale().x / 2 ,  -pSymbol->getScale().x / 2 , pSymbol->getScale().x / 2 ,  pSymbol->getScale().x / 2};
		float tableZ[] = { -pSymbol->getScale().z / 2 ,  pSymbol->getScale().z / 2 , -pSymbol->getScale().z / 2 ,  pSymbol->getScale().z / 2};
		for(int i = 0 ; i < 4 ; i++){
		
			mof::Vector2D pos2D((pos3D.x + tableX[i]) / m_pMapBuilder->getScale() , -(pos3D.z + tableZ[i]) / m_pMapBuilder->getScale());
			if(!et::isWalkableColor(m_pMapBuilder->getMapImageColor(pos2D.x , pos2D.y))){
				//istɉ߂
				//if(m_pHero->getDirection() == et::Symbol::UP)prePos3D.z = -(pos2D.y+1) * m_pMapBuilder->getScale() - tableZ[1]*1.1;
				//else if(m_pHero->getDirection() == et::Symbol::DOWN)prePos3D.z = -(pos2D.y) * m_pMapBuilder->getScale() - tableZ[0]*1.1;
				//else if(m_pHero->getDirection() == et::Symbol::LEFT)prePos3D.x= (pos2D.x+1) * m_pMapBuilder->getScale() - tableX[0]*1.1;
				//else if(m_pHero->getDirection() == et::Symbol::RIGHT)prePos3D.x= (pos2D.x) * m_pMapBuilder->getScale() - tableX[2]*1.1;

				pSymbol->setPosition(prePos3D , pSymbol->getDirection() );//Î~
				pSymbol->update();//߂AjKp
				break;
			}
		
		}
	}
}

bool compareTo( et::Symbol* &a ,  et::Symbol* &b){
		return (*a).getPosition().z > (*b).getPosition().z;
	}

void et::SymbolManager::draw(){
	//zWŃ\[gĕ`
	
	std::sort(m_symbols.begin() , m_symbols.end() , compareTo);
	for(int i = 0 ; i < m_symbols.size() ; i++)m_symbols.at(i)->draw();
}

void et::SymbolManager::add(et::SymbolController* pController){
	m_controllers.push_back(pController);
	for(int i = 0 ; i < pController->getSize() ; i++)m_symbols.push_back(pController->get(i));
}


std::vector<et::Symbol*> et::SymbolManager::testCollision(et::Symbol* pSymbol){
	std::vector<et::Symbol*> touchedList;
	for(int i = 0 ; i < m_symbols.size() ; i++){
		Symbol* pTarget = m_symbols.at(i);
		//~mœ蔻
		if(fabs(pTarget->getPosition().x - pSymbol->getPosition().x) > (pTarget->getScale().x/2 + pSymbol->getScale().x/2))continue;
		else if(fabs(pTarget->getPosition().z - pSymbol->getPosition().z) > (pTarget->getScale().z/2 + pSymbol->getScale().z/2))continue;
		else touchedList.push_back(pTarget);
		
	}
	return touchedList;
}

void et::SymbolManager::create(){
	//_ɓGV{zu
	while(true){
		int x = rand()%m_pMapBuilder->getWidth();
		int y = rand()%m_pMapBuilder->getHeight();
		if(!et::isWalkableColor(m_pMapBuilder->getMapImageColor(x , y)))continue;
		mof::Billboard* pBillboard = new mof::Billboard(mof::Billboard::Y_FIXED , m_pTextureManager->getResource(_T("image/chara2.png")));
		//pBillboard->setTextureRectangle(mof::Line2D(0 , 0 ,32 , 64));
		Symbol* pSymbol = new et::Symbol( pBillboard , mof::Vector3D(0.2f , 0.4f , 0.2f));
		SymbolController* pController = new et::RandomSymbolController();
		
		pController->add(pSymbol);

		mof::Vector3D position(((float)x+0.5f) * m_pMapBuilder->getScale() , 0.0f , (-(float)(y+1)+0.5f) * m_pMapBuilder->getScale());
		pSymbol->setPosition(position , et::Symbol::DOWN );//Î~
		pSymbol->update();

		add(pController);
		break;
	}
}