#include "UsingBattleItemMenu.h"
#include "mof/KeyFrameAnimation.h"
#include "MyWindow.h"
#include "TargetMenu.h"
#include "BattleData.h"
#include "BattlerGroup.h"
#include "BattlerFacade.h"

mof::Window* et::UsingBattleItemMenu::addSelectableTextItem(mof::Window* pOwner, std::vector<mof::Window*>& selectables , TCHAR* text , int size){
	mof::Window* pSelectable = new et::MyWindow(mof::Sprite::createSpriteFromText(text , size) , m_pTextureManager);
	pOwner->add(pSelectable);
	selectables.push_back(pSelectable);
	return pSelectable;
}

et::UsingBattleItemMenu::UsingBattleItemMenu( mof::TextureManager* pTextureManager , et::BattleData* pBattleData )
: et::ItemOperationMenu(pTextureManager->getResource(_T("image/frame0.png")) )
{
	m_pBattleData = pBattleData;

	m_pSelector = NULL;
	m_pTextureManager = pTextureManager;
	std::vector<mof::Window*> selectables;

	mof::Window* pSelectable = NULL;
	addSelectableTextItem(this , selectables , _T("") , 16);
	
	m_pSelector = new mof::SelectionModel(selectables , mof::AnimationResource());
	setVisible(true);
}

et::UsingBattleItemMenu::~UsingBattleItemMenu(void)
{
	delete m_pSelector;
}





void et::UsingBattleItemMenu::setVisible(bool visible){
	et::MyFrame::setVisible(visible);
	if(visible){
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(160 ,500));
		pAnimation->setPosition(10 , mof::Vector2D(160 , 370));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
	else {
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(160 , 370));
		pAnimation->setPosition(10 , mof::Vector2D(160 , 500));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
}

et::MyFrame* et::UsingBattleItemMenu::performAction(){
	et::BattleAction action;
	action.type = et::BattleAction::USE_ITEM;
	action.pTargetItem = m_pItemData;
	action.pTarget = m_pBattleData->getBattlerGroup()->getHeroBattler();
	m_pBattleData->setBattleAction(action);
	return this;
}




et::UsingBattleItemMenuFactory::UsingBattleItemMenuFactory(mof::TextureManager* pTextureManager , et::BattleData* pBattleData){
	m_pTextureManager = pTextureManager;
	m_pBattleData = pBattleData;
}

et::UsingBattleItemMenuFactory::~UsingBattleItemMenuFactory(){

}

et::ItemOperationMenu* et::UsingBattleItemMenuFactory::create(){
	return new UsingBattleItemMenu(m_pTextureManager , m_pBattleData);
}