#include "WorldMenu.h"
#include "mof/KeyFrameAnimation.h"
#include "MyWindow.h"


et::WorldMenu::WorldMenu( mof::TextureManager* pTextureManager , et::World* pWorld , et::GameData* pGameData)
: et::MyFrame(mof::Line2D( 650 , 50 , 800 , 200) , true , pTextureManager->getResource(_T("image/frame0.png")) )
{
	m_pTextureManager = pTextureManager;
	m_pWorld = pWorld;
	m_pGameData = pGameData;
	m_pSelector = NULL;
	std::vector<mof::Window*> selectables;

	mof::Window* pSelectable = NULL;
	add(mof::Sprite::createSpriteFromText(_T("[hj[") , 16) );
	pSelectable = addSelectableTextItem(this , selectables , _T("_WT") , 16);
	pSelectable->setAvailable(false);
	addSelectableTextItem(this , selectables , _T("GAj[") , 16);
	addSelectableTextItem(this , selectables , _T("X[v") , 16);
	pSelectable = addSelectableTextItem(this , selectables , _T("[h") , 16);
	pSelectable->setAvailable(false);
	m_pSelector = new mof::SelectionModel(selectables , mof::AnimationResource());
	setVisible(true);
}




et::WorldMenu::~WorldMenu(void)
{
	delete m_pSelector;
}




void et::WorldMenu::setVisible(bool visible){
	et::MyFrame::setVisible(visible);
	if(visible){
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(650 , 50));
		pAnimation->setPosition(7 , mof::Vector2D(440 , 50));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
	else {
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(440 , 50));
		pAnimation->setPosition(7 , mof::Vector2D(650 , 50));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
}

et::MyFrame* et::WorldMenu::performAction(){
	
	switch(getSelectionModel()->getSelectingIndex()){
		case 0 : //_WT
			return this;
		case 1 : //GAj[
			{
			//[hj[GAj[̑JڃAjZbg
			setVisible(false);
			return NULL;
			}
			case 2 : //X[v
				{
				m_pGameData->addRegenerationEvent(et::RegenerationEvent::createSleepEvent(m_pWorld->getTerm()));
				setVisible(false);
				return NULL;
			}
		default :
			DEBUG_PRINT("`̃ANVv܂");
			return NULL;
	}
}



mof::Window* et::WorldMenu::addSelectableTextItem(mof::Window* pOwner, std::vector<mof::Window*>& selectables , TCHAR* text , int size){
	mof::Window* pSelectable = new et::MyWindow(mof::Sprite::createSpriteFromText(text , size) , m_pTextureManager);
	pOwner->add(pSelectable);
	selectables.push_back(pSelectable);
	return pSelectable;
}