#include "widget/ImageTileView.hpp"
#include "widget/ImageTiler.hpp"
#include <memory>
#include <memory>
#include <mof/streams.hpp>

using std::shared_ptr;
using std::make_shared;
using mof::FrameNumber;
using mof::Texture;
using namespace mof::widget;

//{{{ struct Impl
struct ImageTileView::Impl
{
    ImageTiler tiler;

    Impl( const shared_ptr<Texture>& pTexture )
    : tiler( pTexture )
    {
    }
};
//}}}
//{{{ constructor
ImageTileView::ImageTileView( const shared_ptr<Texture>& pTexture )
: m_pImpl( new Impl (pTexture ) )
{
}
//}}}
//{{{ destructor
ImageTileView::~ImageTileView()
{
}
//}}}
//{{{ show
FrameNumber ImageTileView::show( bool )
{
    return 0;
}
//}}}
//{{{ hide
FrameNumber ImageTileView::hide( bool )
{
    return 0;
}
//}}}
//{{{ focus
FrameNumber ImageTileView::focus( bool )
{
    return 0;
}
//}}}
//{{{ blur
FrameNumber ImageTileView::blur( bool )
{
    return 0;
}
//}}}
//{{{ click
FrameNumber ImageTileView::click( bool )
{
    return 0;
}
//}}}
//{{{ getPreferredSize
mof::Vector2D ImageTileView::getPreferredSize() const
{
    return mof::Vector2D(0, 0);
}
//}}}
//{{{ update
void ImageTileView::update( )
{
    m_positionStream.update( );
    m_sizeStream.update( );
    m_colorStream.update();

    mof::Rectangle<float> region;
    mof::Vector2D position = m_positionStream.value();
    mof::Vector2D size = m_sizeStream.value();
    region.beginX = position.x;
    region.beginY = position.y;
    region.endX = region.beginX + size.x;
    region.endY = region.beginY + size.y;
    m_pImpl->tiler.setRegion( region );
    m_pImpl->tiler.setColor(m_colorStream.value().toColorCode());
    
}
//}}}
//{{{ draw
void ImageTileView::draw( ) const
{
    m_pImpl->tiler.draw( );
}
//}}}
//{{{ setVisible
void ImageTileView::setVisible(bool visible)
{
    m_pImpl->tiler.setVisible(visible);
}
//}}}
