#pragma once
#include <memory>
#include <vector>
#include <mof/mofGraphics.hpp>


typedef mof::VertexXYZCUV VertexTypeMap;

class MapBuilder
{
	
	float m_scale;
	int m_width;
	int m_height;
	
protected :
	virtual void addParts(std::vector<VertexTypeMap>& vertices , int x , int y) = 0;
public:
	MapBuilder(float scale, int width, int height);
	virtual ~MapBuilder(void);
	std::unique_ptr<mof::Graphics3D> create();// TODO
	float getScale();

	int getWidth(){return m_width;}
	int getHeight(){return m_height;}
};


