#!__PREFIX__/local/bin/perl
# $Id: fcgi.pl 14 2011-07-07 03:06:41Z bobunderson $

use strict;
use warnings;

use FindBin;
use IO::Socket::INET;
use Mojo::Server::FastCGI;

use lib join( '/', $FindBin::Bin, '..', 'lib', 'perl' );

&main();

sub main {

    # デーモン化
    &daemonize();

    # ログ出力設定
    my $access_log = '__PREFIX__/var/log/access_log';
    my $error_log  = '__PREFIX__/var/log/error_log';
    &set_log_output( $access_log, $error_log );

    my $sock = new IO::Socket::INET(
        'Proto'     => 'tcp',
        'Reuse'     => 1,
        'Listen'    => 100,
        'LocalPort' => 8999,
        'LocalAddr' => 'localhost'
    );

    my $fcgi
        = new Mojo::Server::FastCGI( 'app_class' => 'MojoWiki::MojoDaemon' );

    $fcgi->{'listen'} = $sock;

    $fcgi->run;
}

sub daemonize {
    $SIG{CHLD} = 'IGNORE';

    my $pid = fork();

    if ( $pid < 0 ) {
        exit -1;
    }
    elsif ($pid) {
        exit 0;
    }

    $SIG{CHLD} = 'DEFAULT';

    open( STDOUT, ">/dev/null" );
    open( STDERR, ">/dev/null" );
    open( STDIN,  "</dev/null" );
}

sub set_log_output {
    my ( $access_log, $error_log ) = @_;

    if ( defined($access_log) ) {
        open( STDOUT, ">>$access_log" );
    }
    else {
        open( STDOUT, ">/dev/null" );
    }

    if ( defined($error_log) ) {
        open( STDERR, ">>$error_log" );
    }
    else {
        open( STDERR, ">/dev/null" );
    }
}
