package MojoWiki::MojoDaemon;
##
## daemonの初期設定
## $Id: MojoDaemon.pm 3 2011-06-17 14:51:48Z bobunderson $
##

use strict;
use warnings;

use Encode;
use FindBin;
use Mojo::Base 'Mojolicious';
use Template;
use UNIVERSAL::require;

use lib join( '/', $FindBin::Bin, '..' );
use MojoWiki::Constants;
use MojoWiki::YAML;

my @URL_MAPS = (
    {   'url'        => URL_PREFIX,
        'controller' => 'page',
        'action'     => 'index'
    },
    {   'url'        => URL_PREFIX . 'static/(*path)',
        'controller' => 'static',
        'action'     => 'file'
    },
    {   'url'        => URL_PREFIX . '(*path)',
        'controller' => 'page',
        'action'     => 'page'
    },
);

# This method will run once at server start
sub startup {
    my $self = shift;

    # Documentation browner under "/perldoc" (this plugin requires Perl 5.10)
    $self->plugin('pod_renderer');

    # TemplateToolkitレンダラ
    $self->renderer->add_handler( 'tt' => \&tt_handler );
    $self->renderer->default_handler('tt');

    # 静的ファイルのパスを指定
    $self->static->root(STATIC_DIR);

    # Routes
    my $r = $self->routes;
    foreach my $map (@URL_MAPS) {
        my $url        = $map->{'url'};
        my $controller = $map->{'controller'};
        my $action     = $map->{'action'};

        $r->route($url)
            ->to( 'controller' => $controller, 'action' => $action );
    }

    # 設定ファイル読み込み
    $self->{'config'} = MojoWiki::YAML::load_yaml(CONFIG_PATH);

    # DB接続
    $self->_connect_db();
}

sub _connect_db {
    my ( $self ) = @_;

    my $storage_type = $self->config->{'Storage'}->{'Type'};
    my $module_name = 'MojoWiki::Storage::' . $storage_type;
    $module_name->use();

    my $storage_option = $self->config->{'Storage'}->{'Option'};

    $self->{'db'} = new $module_name($storage_option);
}

sub tt_handler {
    my ( $r, $c, $output, $options ) = @_;

    my $tt = new Template( { 'ABSOLUTE' => 1 } );

    my $template_name = $c->{'app'}->renderer->template_name($options);

    my $template_path = join( '/', TEMPLATE_DIR, $template_name );

    my $template_param = $c->stash;
    my $html;
    $tt->process( $template_path, $template_param, \$html );

    # utf8フラグを立てる
    $$output = Encode::decode_utf8($html);
}

sub db {
    my ($self) = @_;

    return $self->{'db'};
}

sub config {
    my ($self) = @_;

    return $self->{'config'};
}

1;
