package MojoWiki::PageParts;
##
## 全ページに共通するパーツを生成する
## $Id: PageParts.pm 19 2011-07-20 09:01:40Z bobunderson $
##

use strict;
use warnings;

use Encode;
use FindBin;
use Template;

use lib join( '/', $FindBin::Bin, '..' );
use MojoWiki::Constants;
use MojoWiki::WikiFormatter;

##
## コンストラクタ
##
sub new {
    my ( $class, @args ) = @_;

    my $self = {};

    bless( $self, $class );

    $self->_init(@args);

    return $self;
}

##
## フィールドの初期化
## 引数
##   $controller MojoWiki::MojoDaemon::Page クラスのインスタンス
##
sub _init {
    my ( $self, $controller ) = @_;

    $self->{'controller'} = $controller;
}

##
## ヘッダ部分のHTMLを返す
## 引数
##   $args = {
##      'title' => ページ名部分に表示する文字列
##   }
## 戻り値
##   ヘッダ部分のHTML
##
sub get_header {
    my ( $self, $args ) = @_;

    my $path = $self->{'controller'}->stash('path');
    my $page = $self->{'controller'}->app->db->get_page($path);
    if ( !defined($page) ) {
        $page->{'Title'} = '/' . $path;
    }

    my $tt = new Template( { 'ABSOLUTE' => 1 } );
    my $template_path
        = join( '/', TEMPLATE_DIR, 'include', 'header.html.tt' );
    my $template_param;
    $template_param->{'wikiname'}
        = $self->{'controller'}->app->config->{'WikiName'};
    $template_param->{'url_prefix'} = URL_PREFIX;
    $template_param->{'url'}
        = $self->{'controller'}->tx->req->url->path->to_string();
    $template_param->{'title'} = $args->{'title'}
        || Encode::encode_utf8( $page->{'Title'} );

    my $html;
    $tt->process( $template_path, $template_param, \$html );

    return Encode::decode_utf8($html);
}

##
## 画面左側のナビゲータ部分のHTMLを返す
## 戻り値
##   ナビゲータ部分のHTML
##
sub get_navigator {
    my ($self) = @_;

    my $tt = new Template( { 'ABSOLUTE' => 1 } );
    my $template_path
        = join( '/', TEMPLATE_DIR, 'include', 'navigator.wiki.tt' );
    my $template_param;

    my $plain_wiki;
    $tt->process( $template_path, $template_param, \$plain_wiki );

    my $formatter = new MojoWiki::WikiFormatter( $self->{'controller'} );
    $plain_wiki = $formatter->head_index($plain_wiki);
    my $contents = $formatter->format($plain_wiki);

    return Encode::decode_utf8($contents);
}

##
## フッタ部分のHTMLを返す
## 引数
##   $args = {
##      'revision' => 表示するページのリビジョン番号
##   }
## 戻り値
##   フッタ部分のHTML
##
sub get_footer {
    my ( $self, $args ) = @_;

    my $path = $self->{'controller'}->stash('path');
    my $page = $self->{'controller'}->app->db->get_page($path);
    if ( !defined($page) ) {
        $page->{'Revision'} = 0;
    }

    my $tt = new Template( { 'ABSOLUTE' => 1 } );
    my $template_path
        = join( '/', TEMPLATE_DIR, 'include', 'footer.wiki.tt' );
    my $template_param;
    $template_param->{'revision'} = $args->{'revision'}
        || $page->{'Revision'};

    my $plain_wiki;
    $tt->process( $template_path, $template_param, \$plain_wiki );

    my $formatter = new MojoWiki::WikiFormatter( $self->{'controller'} );
    $plain_wiki = $formatter->head_index($plain_wiki);
    my $contents = $formatter->format($plain_wiki);

    return Encode::decode_utf8($contents);
}

1;
