package MojoWiki::Plugins::AbstractBlockPlugin;
##
## ブロック型プラグインの抽象クラス
## $Id: AbstractBlockPlugin.pm 8 2011-06-22 08:27:57Z bobunderson $
##

use strict;
use warnings;

use FindBin;
use Mojolicious::Controller;

use lib join( '/', $FindBin::Bin, '..', '..' );

##
## 処理可能なプラグイン名のリストを返す
##
sub processable_plugins {
    my ($self) = @_;

    my $plugins = $self->{'block_plugins'};

    return @$plugins;
}

##
## 指定されたプラグイン名が処理可能なら1を返す
## 引数
##   $plugin_name プラグイン名
## 戻り値
##   1 処理可能
##   0 処理不能
##
sub is_processable_block {
    my ( $self, $plugin_name ) = @_;

    my $plugins = $self->{'block_plugins'};

    if ( grep( /^$plugin_name$/, @$plugins ) ) {
        return 1;
    }
    else {
        return 0;
    }
}

##
## プラグインを処理する
## 引数
##   $plugin_name プラグイン名
##   $path ページのパス
##   $args_str 引数の文字列
## 戻り値
##   処理結果のHTML
##
sub process_block_plugin {
    my ( $self, $plugin_name, $path, $args_str ) = @_;

    die 'process_block_plugin is not overridden';
}

##
## ページが削除された際に、当該ページに紐づくデータの後始末をする
## 引数
##   $path 削除されたページのパス
##
sub delete_page {
    my ( $self, $path ) = @_;

    #die 'delete_page is not overridden';
}

1;
