package MojoWiki::Plugins::counter;

use Encode;
use FindBin;
use Time::Local;

use lib join( '/', $FindBin::Bin, '..', '..' );

use base qw(
    MojoWiki::Plugins::AbstractInlinePlugin
);

sub new {
    my ( $class, $controller, @args ) = @_;

    my $self = {};

    bless( $self, $class );

    $self->{'inline_plugins'} = ['counter'];
    $self->{'controller'}     = $controller;
    $self->{'db'}             = $controller->app->db;

    return $self;
}

sub process_inline_plugin {
    my ( $self, $plugin_name, $path, $args_str ) = @_;

    if ( $plugin_name eq 'counter' ) {
        return &_counter( $self, $path );
    }
    else {
        die 'unprocessable!!';
    }
}

sub _counter {
    my ( $self, $path ) = @_;

    # DBからページのアクセス数を取得
    my ($count) = $self->{'db'}->plugin_get( 'counter', $path );
    $count = $count || 0;

    # 1を足してDBに保存
    my $mode = $self->{'controller'}->tx->req->params->param('cmd');
    if ( !defined($mode) || $mode eq 'view' ) {
        $count++;
        $self->{'db'}->plugin_set( 'counter', $path, $count );
    }

    return $count;
}

sub delete_page {
    my ( $self, $path ) = @_;

    $self->{'db'}->plugin_set( 'counter', $path );
}

1;
