package MojoWiki::Storage::AbstractStorage;
##
## ページの保存機能、プラグインが利用するKVS機能を提供するストレージの抽象クラス
## $Id: AbstractStorage.pm 3 2011-06-17 14:51:48Z bobunderson $
##

use strict;
use warnings;

use FindBin;

use lib join( '/', $FindBin::Bin, '..', '..' );

##
## ページの内容を取得する
## 引数
##   $path ページのパス
## 戻り値
##   {
##      'Title'        => タイトル
##      'Body'         => 本文のWikiテキスト
##      'Revision'     => ページのリビジョン番号
##      'CreatedTime'  => 作成日時(UNIX Time)
##      'ModifiedTime' => 最終更新日時(UNIX Time)
##   }
##
sub get_page {
    my ( $self, $path ) = @_;

    die 'this method must be overridden';
}

##
## ページを保存する
## 引数
##   $path ページのパス
##   $page = {
##      'Title' => タイトル
##      'Body'  => 本文のWikiテキスト
##   }
##
sub set_page {
    my ( $self, $path, $page ) = @_;

    die 'this method must be overridden';
}

##
## ページを削除する
## 引数
##   $path ページのパス
##
sub delete_page {
    my ( $self, $path ) = @_;

    die 'this method must be overridden';
}

##
## 最終更新日が最新のページを取得する
## 引数
##   $n 取得する最大件数
## 戻り値
##   (
##      {
##         'Title'        => タイトル
##         'Body'         => 本文のWikiテキスト
##         'Revision'     => ページのリビジョン番号
##         'CreatedTime'  => 作成日時(UNIX Time)
##         'ModifiedTime' => 最終更新日時(UNIX Time)
##      }, ...
##   )
##
sub get_newest_page {
    my ( $self, $n ) = @_;

    die 'this method must be overridden';
}

##
## プラグインが利用可能な Key-Value Store 機能
## 引数
##   $plugin_name プラグイン名
##   $key キー
##   @values 値の配列
##
sub plugin_set {
    my ( $self, $plugin_name, $key, @values ) = @_;

    # undef が plugin_set されたら key も削除すること

    die 'this method must be overridden';
}

##
## プラグインが利用可能な Key-Value Store 機能
## 引数
##   $plugin_name プラグイン名
##   $key キー
## 戻り値
##   (
##      '値1',
##      '値2', ...
##   )
##
sub plugin_get {
    my ( $self, $plugin_name, $key ) = @_;

    die 'this method must be overridden';
}

1;
