package MojoWiki::Storage::MySQL::Schema::Result::KVS_Key;

use strict;
use warnings;

use base qw/DBIx::Class::Core/;

my $table   = 'KVS_KEY';
my @columns = qw(id plugin_name name);

__PACKAGE__->table($table);
__PACKAGE__->add_columns(@columns);
__PACKAGE__->set_primary_key('id');
__PACKAGE__->add_unique_constraint( ['plugin_name', 'name'] );

__PACKAGE__->has_many(
    'kvs_values' => 'MojoWiki::Storage::MySQL::Schema::Result::KVS_Value',
    'key_id'
);

1;
