package com.mokit.util;

import com.nttdocomo.ui.PhoneSystem;

/**
 * [A@\ɃANZX邽߂̋@\񋟂܂B
 *
 * @author Takuto Nishioka
 */
public class Device {
	
	/**
	 * sȃp^\܂B
	 */
	public static final int UNKNOWN_ATTR = -1;
	
	/**
	 * drcʂ̑A[dł邱Ƃ\܂B
	 */
	public static final int BATTERY_CHARGING = PhoneSystem.ATTR_BATTERY_CHARGING;	

	/**
	 * drcʂ̑A[dłȂAsNg\FULLł邱Ƃ\܂B
	 */
	public static final int BATTERY_FULL = PhoneSystem.ATTR_BATTERY_FULL;	
	
	/**
	 * drcʂ̑A[dłȂAsNg\FULLȊOł邱Ƃ\܂B
	 */
	public static final int BATTERY_PARTIAL = PhoneSystem.ATTR_BATTERY_PARTIAL;
	
	/**
	 * dEx̑Ał邱Ƃ\܂B
	 * Doja5.1ȍ~͔񐄏
	 */
	public static final int SERVICEAREA_INSIDE = PhoneSystem.ATTR_SERVICEAREA_INSIDE;
	
	/**
	 * dEx̑AO(Zt[h܂)ł邱Ƃ\܂B<br>
	 * Doja5.1ȍ~͔񐄏
	 */
	public static final int SERVICEAREA_OUTSIDE = PhoneSystem.ATTR_SERVICEAREA_OUTSIDE;
	
	/**
	 * }i[[h̑AIł邱Ƃ\܂B
	 */
	public static final int MANNER_ON  = PhoneSystem.ATTR_MANNER_ON ;
	
	/**
	 * }i[[h̑AItł邱Ƃ\܂B
	 */
	public static final int MANNER_OFF  = PhoneSystem.ATTR_MANNER_OFF;
	

	/**
	 * RXgN^͉܂B
	 * 
	 */
	private Device(){		
	}
	

	/**
	 * PhoneSystem̃p^Zbg܂B
	 * 
	 * @param attr		lCeBu\[X̎ނw肵܂B
	 * @param value	lCeBu\[Xɐݒ肷鑮lw肵܂B
	 */
	private static void setAttribute(int attr, int value){
		try{
			PhoneSystem.setAttribute(attr, value);
			
		}catch(IllegalArgumentException e){
			//ȃ^Cvw肳ꂽꍇ
			e.printStackTrace();
		}
	}

	
	/**
	 * PhoneSystem̃p^擾܂B
	 * 
	 * @param attr		lCeBu\[X̎ނw肵܂B
	 * @return			lCeBu\[Xɐݒ肷鑮lԂ܂B
	 */
	private static int getAttribute(int attr){
		try{
			return PhoneSystem.getAttribute(attr);
			
		}catch(IllegalArgumentException e){
			//ȃ^Cvw肳ꂽꍇ
			e.printStackTrace();
			
		}catch(SecurityException e){
			//ADF̋LqȂꍇ
			e.printStackTrace();
		}
		return UNKNOWN_ATTR;
	}

	
	/**
	 * oCu[^Jn܂B
	 *
	 */
	public static void startVibrator(){
		setAttribute(PhoneSystem.DEV_VIBRATOR, PhoneSystem.ATTR_VIBRATOR_ON);
	}
	

	/**
	 * oCu[^I܂B
	 *
	 */
	public static void stopVibrator(){
		setAttribute(PhoneSystem.DEV_VIBRATOR, PhoneSystem.ATTR_VIBRATOR_OFF);
	}


	/**
	 * obNCg_܂B
	 *
	 */
	public static void putOnBacklight(){
		setAttribute(PhoneSystem.DEV_BACKLIGHT, PhoneSystem.ATTR_BACKLIGHT_ON);
	}
	

	/**
	 * obNCg܂B
	 *
	 */
	public static void putOffBacklight(){
		setAttribute(PhoneSystem.DEV_BACKLIGHT, PhoneSystem.ATTR_BACKLIGHT_OFF);
	}

	
	/**
	 * drcʂ̏Ԃ擾܂B<br>
	 * <p>ADF GetSysInfo=yes w肷Kv܂B</p>
	 * 
	 * @return	펞͓drcʂ̑AG[ɂ UNKNOWN_ATTR Ԃ܂B
	 */
	public static int getBattery(){
		return getAttribute(PhoneSystem.DEV_BATTERY);
	}


	/**
	 * dg̏Ԃ擾܂B
	 * <p>ADF GetSysInfo=yes w肷Kv܂B</p>
	 * 
	 * @return	펞͓dEx̑AG[ɂ UNKNOWN_ATTR Ԃ܂B
	 */	
	public static int getServiceareaInfo(){
		return getAttribute(PhoneSystem.DEV_SERVICEAREA);
	}
	
	
	/**
	 * }i[[hǂ擾܂B
	 * <p>ADF GetSysInfo=yes w肷Kv܂B</p>
	 * 
	 * @return	펞̓}i[[h̑AG[ɂ UNKNOWN_ATTR Ԃ܂B
	 */	
	public static int getMannerMode(){
		return getAttribute(PhoneSystem.DEV_MANNER);
	}
	
}
