/*
 * Decompiled with CFR 0.152.
 */
package mokit.io;

import com.nttdocomo.util.JarInflater;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;

public class StoreManager {
    public static final int NO_1 = 0;
    public static final int NO_2 = 1;
    public static final int NO_3 = 2;
    private static final int[] _SIZE = new int[]{1000, 1000, 1000};

    private void checkSize(int n, int n2, int n3) throws IOException {
        if (n >= _SIZE.length) {
            throw new IOException("[checkSize \u7121\u52b9\u306a\u9818\u57df] area=" + n + ", offset=" + n2 + ", len=" + n3);
        }
        if (n2 + n3 > _SIZE[n]) {
            throw new IOException("[checkSize overflow] area=" + n + ", offset=" + n2 + ", len=" + n3);
        }
    }

    public void clear(int n) throws IOException {
        this.checkSize(n, 0, 0);
        this.write(new byte[_SIZE[n]], n, 0);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException, NullPointerException {
        if (byArray == null) {
            throw new NullPointerException("[write null] area=" + n + ", offset=" + n2);
        }
        this.checkSize(n, n2, byArray.length);
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = Connector.openDataOutputStream((String)("scratchpad:///" + n + ";pos=" + n2));
            filterOutputStream.write(byArray);
            ((DataOutputStream)filterOutputStream).flush();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + "[write] area=" + n + ", offset=" + n2);
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            filterOutputStream = null;
        }
    }

    public byte[] read(int n, int n2, int n3) throws IOException {
        this.checkSize(n, n2, n3);
        byte[] byArray = new byte[n3];
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = Connector.openDataInputStream((String)("scratchpad:///" + n + ";pos=" + n2));
            ((DataInputStream)filterInputStream).read(byArray);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + "[read] area=" + n + ", offset=" + n2 + ", len=" + n3);
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {}
            filterInputStream = null;
        }
        return byArray;
    }

    public InputStream readJar(int n, int n2, int n3, String string) throws IOException {
        this.checkSize(n, n2, n3);
        InputStream inputStream = null;
        JarInflater jarInflater = null;
        try {
            byte[] byArray = this.read(n, n2, n3);
            if (byArray != null) {
                jarInflater = new JarInflater(byArray);
                inputStream = jarInflater.getInputStream(string);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage() + "[readJar] area=" + n + ", offset=" + n2 + ", len=" + n3 + ", fname=" + string);
        }
        finally {
            if (jarInflater != null) {
                jarInflater.close();
            }
            jarInflater = null;
        }
        return inputStream;
    }
}

