package mokit.common;

import mokit.util.Logger;

import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Display;
import com.nttdocomo.ui.Frame;
import com.nttdocomo.ui.Graphics;

/**
 * LoXʂ̃CNXłB<br>
 * 
 * @author Takuto Nishioka
 */
public class BaseCanvas extends Canvas {

	/**
	 * L[\܂B
	 */
	public static final int UP = Display.KEY_UP;

	/**
	 * L[\܂B
	 */
	public static final int DOWN = Display.KEY_DOWN;

	/**
	 * L[\܂B
	 */
	public static final int LEFT = Display.KEY_LEFT;

	/**
	 * EL[\܂B
	 */
	public static final int RIGHT = Display.KEY_RIGHT;

	/**
	 * L[\܂B
	 */
	public static final int SELECT = Display.KEY_SELECT;

	/**
	 * 0L[\܂B
	 */
	public static final int KEY_0 = Display.KEY_0;

	/**
	 * 1L[\܂B
	 */
	public static final int KEY_1 = Display.KEY_1;

	/**
	 * 2L[\܂B
	 */
	public static final int KEY_2 = Display.KEY_2;

	/**
	 * 3L[\܂B
	 */
	public static final int KEY_3 = Display.KEY_3;

	/**
	 * 4L[\܂B
	 */
	public static final int KEY_4 = Display.KEY_4;

	/**
	 * 5L[\܂B
	 */
	public static final int KEY_5 = Display.KEY_5;

	/**
	 * 6L[\܂B
	 */
	public static final int KEY_6 = Display.KEY_6;

	/**
	 * 7L[\܂B
	 */
	public static final int KEY_7 = Display.KEY_7;

	/**
	 * 8L[\܂B
	 */
	public static final int KEY_8 = Display.KEY_8;

	/**
	 * 9L[\܂B
	 */
	public static final int KEY_9 = Display.KEY_9;

	/**
	 * *L[\܂B
	 */
	public static final int KEY_AST = Display.KEY_ASTERISK;

	/**
	 * #L[\܂B
	 */
	public static final int KEY_PND = Display.KEY_POUND;

	/**
	 * NAL[\܂B
	 */
	public static final int KEY_IAPP = Display.KEY_IAPP;

	/**
	 * \tgL[1\܂B
	 */
	public static final int KEY_SOFT1 = Display.KEY_SOFT1;

	/**
	 * \tgL[2\܂B
	 */
	public static final int KEY_SOFT2 = Display.KEY_SOFT2;

	/**
	 * L[ĂȂԂ\܂B
	 */
	public static final int KEY_NONE = -999;

	/**
	 * \tgL[1̃x\܂B
	 */
	public static final int SOFT_LABEL_1 = Frame.SOFT_KEY_1;

	/**
	 * \tgL[2̃x\܂B
	 */
	public static final int SOFT_LABEL_2 = Frame.SOFT_KEY_2;

	/**
	 * L[_ECxg\܂B
	 */
	public static final int PRESSED_EVENT = Display.KEY_PRESSED_EVENT;

	/**
	 * L[AbvCxg\܂B
	 */
	public static final int RELEASED_EVENT = Display.KEY_RELEASED_EVENT;

	// L[Ɏgp
	private static int keyEvent;

	// 𔻒肷ۂ͂gp
	private static int keyState;

	// CanvasXbhI
	private static boolean continueThread;

	// CanvasIɕԂl
	private static int retValue;

	/**
	 * Canvas`惁\bhłB<br>
	 * LoXؑ֎ɎŌĂ΂܂B
	 * 
	 * @param g
	 *          GraphicsCX^X
	 */
	public void paint(Graphics g) {

		G.setGraphics(g);
		G.lock();
		paintCvs();
		G.unlock(true);
	}

	/**
	 * Canvasĕ`悵܂B
	 * 
	 */
	public void repaintCvs() {

		G.lock();
		paintCvs();
		G.unlock(true);
	}

	/**
	 * TuNXŃI[o[Ch܂B
	 * 
	 */
	public void paintCvs() {

	}

	/**
	 * CanvasɋN郁C[vłB
	 * 
	 * @param time
	 *          X[vԊu
	 * @return MainXbh֔Cӂ̒lԂ܂B
	 */
	public int startCvsThread(int time) {
		
		Logger.add(Logger.SYS, "[cvs] startCvsThread(" + time + ")");
		continueThread = true;
		keyEvent = KEY_NONE;
		keyState = 0;

		while (continueThread) {
			exe(keyEvent, keyState);
			keyEvent = KEY_NONE;
			try {
				Thread.sleep(time);
			} catch (Exception e) {
			}
		}
		return retValue;
	}

	/**
	 * TuNXŃI[o[Ch܂B
	 * 
	 * @param keyEvent
	 *          xpL[p^
	 * @param keyState
	 *          ςȂpL[p^
	 */
	public void exe(int keyEvent, int keyState) {

	}

	/**
	 * CanvasXbhI܂B
	 * 
	 * @param nextMode
	 *          MainXbh֕Ԃl
	 */
	public void endCvsThread(int nextMode) {

		retValue = nextMode;
		continueThread = false;
	}

	/**
	 * \tgL[xݒ肵܂B
	 * 
	 * @param key1
	 *          \tgL[1̃x
	 * @param key2
	 *          \tgL[2̃x
	 */
	public void setSoftLabel(String key1, String key2) {

		if (key1 != null) setSoftLabel(SOFT_LABEL_1, key1);
		if (key2 != null) setSoftLabel(SOFT_LABEL_2, key2);
	}

	/**
	 * L[CxgۂɌĂ΂܂B<br>
	 * LϐZbg܂B
	 * 
	 * <p>
	 * keyEvent : xpL[p^<br>
	 * keyState : ςȂpL[p^
	 * </p>
	 * 
	 * @param type
	 *          L[Cxg
	 * @param param
	 *          L[Cxgp^
	 */
	public void processEvent(int type, int param) {

		keyState = getKeypadState();
		if (type == PRESSED_EVENT) {
			keyEvent = param;
		}
		if (type == RELEASED_EVENT) {
		}
	}

	/**
	 * ̔s܂B
	 * 
	 * @param key1
	 *          ΏۃL[1
	 * @param key2
	 *          ΏۃL[2
	 * @return w肳ꂽL[ɉĂ ture Ԃ܂B
	 */
	public boolean checkMultiKey(int key1, int key2) {

		if (0 != (1 << key1 & keyState) && 0 != (1 << key2 & keyState)) return true;
		return false;
	}

	/**
	 * L[s܂B<br>
	 * iςȂ or 1x̂ǂ炩LłΉĂƔj
	 * 
	 * @param key
	 *          ΏۃL[
	 * @return w肳ꂽL[Ă ture Ԃ܂B
	 */
	public boolean checkKey(int key) {

		if (0 != (1 << key & keyState) || keyEvent == key) return true;
		return false;
	}

}
