package mokit.util;

/**
 * ̕ϊs\bhWłB<br>
 * 
 * [Ql] http://www7a.biglobe.ne.jp/~java-master/samples/string/index.html
 * 
 * @author Nishika Takuto
 */

public class Convertor {

	/**
	 * Spϊw肷萔łB
	 */
	public static final int ZENKAKU = 0;

	/**
	 * pϊw肷萔łB
	 */
	public static final int HANKAKU = 1;

	/**
	 * Ђ炪ȕϊw肷萔łB
	 */
	public static final int HIRAKANA = 2;

	/**
	 * J^Jiϊw肷萔łB
	 */
	public static final int KATAKANA = 3;

	/**
	 * pJiϊe[ułB
	 */
	private static final char[] HAN_KANA = {
			'', '', '', '', '', '', '', '', '', '', '', 
			'', '', '', '', '', '', '', '', '', '', '',
			'', '', '', '', '', '', '', '',	'', '', '', 
			'', '', '', '', '', '', '', '', '', '', '', 
			'', '', '', '', '', '', '', '', '', '', '', 
			'', '', '', '', '', '', '', ''
	};

	/**
	 * SpJiϊe[ułB
	 */
	private static final char[] ZEN_KANA = {
			'B', 'u', 'v', 'A', 'E', '', '@', 'B', 'D', 
			'F', 'H', '', '', '', 'b', '[', 'A', 'C', 
			'E', 'G', 'I', 'J', 'L', 'N', 'P', 'R', 'T', 
			'V', 'X', 'Z',	'\', '^', '`', 'c', 'e', 'g', 
			'i', 'j', 'k', 'l', 'm', 'n', 'q', 't', 'w', 
			'z', '}', '~', '', '', '', '', '', '', 
			'', '', '', '', '', '',	'', 'J', 'K'
	};

	/**
	 * pJi̍ŏ̕łB
	 */
	private static final char HAN_KANA_FIRST = HAN_KANA[0];

	/**
	 * pJi̍Ō̕łB
	 */
	private static final char HAN_KANA_LAST = HAN_KANA[HAN_KANA.length - 1];

	/**
	 * Sp̔pϊ܂B
	 * 
	 * @param str
	 *          ϊΏە
	 * @param type
	 *          ZENKAKU(0), HANKAKU(1)
	 * @return ϊĕԂ܂B
	 */
	public static String cnvNumber(String str, int type) {

		if (str.length() == 0) return "";

		StringBuffer sb = new StringBuffer(str);
		for (int i = 0, len = sb.length(); i < len; i++) {
			char c = sb.charAt(i);
			if (type == HANKAKU) {
				if ('O' <= c && c <= 'X') {
					sb.setCharAt(i, (char) (c - 'O' + '0'));
				}
			} else {
				if ('0' <= c && c <= '9') {
					sb.setCharAt(i, (char) (c - '0' + 'O'));
				}
			}
		}
		return sb.toString();
	}

	/**
	 * pSp̔pϊ܂B
	 * 
	 * @param str
	 *          ϊΏە
	 * @param type
	 *          ZENKAKU(0), HANKAKU(1)
	 * @return ϊĕԂ܂B
	 */
	public static String cnvAlphabet(String str, int type) {

		if (str.length() == 0) return "";

		StringBuffer sb = new StringBuffer(str);
		for (int i = 0, len = sb.length(); i < len; i++) {
			char c = sb.charAt(i);
			if (type == HANKAKU) {
				if ('' <= c && c <= '') {
					sb.setCharAt(i, (char) (c - '' + 'a'));
				} else if ('`' <= c && c <= 'y') {
					sb.setCharAt(i, (char) (c - '`' + 'A'));
				}
			} else {
				if ('a' <= c && c <= 'z') {
					sb.setCharAt(i, (char) (c - 'a' + ''));
				} else if ('A' <= c && c <= 'Z') {
					sb.setCharAt(i, (char) (c - 'A' + '`'));
				}
			}
		}
		return sb.toString();
	}

	/**
	 * ȁ̃Jiϊ܂B
	 * 
	 * @param str
	 *          ϊΏە
	 * @param type
	 *          HIRAKANA(2), KATAKANA(2)
	 * @return ϊĕԂ܂B
	 */
	public static String cnvKana2(String str, int type) {

		if (str.length() == 0) return "";

		StringBuffer sb = new StringBuffer(str);
		for (int i = 0; i < sb.length(); i++) {
			char c = sb.charAt(i);
			if (type == HIRAKANA) {
				if ('@' <= c && c <= '') {
					sb.setCharAt(i, (char) (c - '@' + ''));
				} else if (c == '') {
					sb.setCharAt(i, '');
				} else if (c == '') {
					sb.setCharAt(i, '');
				} else if (c == '') {
					sb.setCharAt(i, '');
					sb.insert(i + 1, 'J');
					i++;
				}
			} else {
				if ('' <= c && c <= '') {
					sb.setCharAt(i, (char) (c - '' + '@'));
				}
			}
		}
		return sb.toString();
	}

	/**
	 * pJ^JiSpJ^Ji֕ϊ܂B
	 * 
	 * @param str
	 *          ϊΏە
	 * @return ϊĕԂ܂B
	 */
	public static String cnvKana(String str) {

		if (str.length() == 0) return "";
		if (str.length() == 1) return cnvKanaChar(str.charAt(0)) + "";

		StringBuffer sb = new StringBuffer(str);
		int i = 0;
		for (i = 0; i < sb.length() - 1; i++) {
			char originalChar1 = sb.charAt(i);
			char originalChar2 = sb.charAt(i + 1);
			char margedChar = mergeKanaChar(originalChar1, originalChar2);
			if (margedChar != originalChar1) {
				sb.setCharAt(i, margedChar);
				sb.deleteCharAt(i + 1);
			} else {
				char convertedChar = cnvKanaChar(originalChar1);
				if (convertedChar != originalChar1) {
					sb.setCharAt(i, convertedChar);
				}
			}
		}
		if (i < sb.length()) {
			char originalChar1 = sb.charAt(i);
			char convertedChar = cnvKanaChar(originalChar1);
			if (convertedChar != originalChar1) {
				sb.setCharAt(i, convertedChar);
			}
		}
		return sb.toString();
	}

	/**
	 * pJ^JiSpJ^Ji֕ϊ܂B
	 * 
	 * @param c
	 *          ϊO̕
	 * @return ϊ̕Ԃ܂B
	 */
	private static char cnvKanaChar(char c) {

		if (c >= HAN_KANA_FIRST && c <= HAN_KANA_LAST) {
			return ZEN_KANA[c - HAN_KANA_FIRST];
		} else {
			return c;
		}
	}

	/**
	 * 2ڂ_E_ŁA1ڂɉ邱Ƃłꍇ́AԂ܂B <br>
	 * łȂƂ́Ac1Ԃ܂B
	 * 
	 * @param c1
	 *          ϊO1
	 * @param c2
	 *          ϊO2
	 * @return ϊ̕Ԃ܂B
	 */
	private static char mergeKanaChar(char c1, char c2) {

		if (c2 == '') {
			// "..." ƂƃJ̔肪肭sȂ
			if ("_".indexOf(c1) > 0) {
				switch (c1) {
					case '':
						return 'K';
					case '':
						return 'M';
					case '':
						return 'O';
					case '':
						return 'Q';
					case '':
						return 'S';
					case '':
						return 'U';
					case '':
						return 'W';
					case '':
						return 'Y';
					case '':
						return '[';
					case '':
						return ']';
					case '':
						return '_';
					case '':
						return 'a';
					case '':
						return 'd';
					case '':
						return 'f';
					case '':
						return 'h';
					case '':
						return 'o';
					case '':
						return 'r';
					case '':
						return 'u';
					case '':
						return 'x';
					case '':
						return '{';
				}
			}
		} else if (c2 == '') {
			if ("_".indexOf(c1) > 0) {
				switch (c1) {
					case '':
						return 'p';
					case '':
						return 's';
					case '':
						return 'v';
					case '':
						return 'y';
					case '':
						return '|';
				}
			}
		}
		return c1;
	}

}
