/*
 * Decompiled with CFR 0.152.
 */
package mokit.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import mokit.exception.MktIOException;
import mokit.io.HttpReceivedEvent;
import mokit.ui.BaseMain;
import mokit.util.ByteUtil;

public class HttpManager
extends Thread {
    private static HttpManager _manager;
    private Vector _que;
    private boolean _isRun;
    private static final int WAIT_QUE = 1000;

    private HttpManager() {
        if (_manager == null) {
            _manager = this;
        }
    }

    public static HttpManager getInstance() {
        if (_manager == null) {
            new HttpManager();
        }
        return _manager;
    }

    public void initQueThread() {
        if (this._isRun && this._que != null) {
            return;
        }
        this._que = new Vector();
        this._isRun = true;
        this.start();
    }

    public void stopQueThread() {
        this._isRun = false;
    }

    public void push(HttpReceivedEvent reciever, String url, String post, String[] option) throws MktIOException {
        if (this._que == null) {
            throw new MktIOException(2, "[push-null] url=" + url + ", post=" + post);
        }
        this._que.addElement(new HttpQue(reciever, url, post, option));
    }

    private HttpQue pop() {
        HttpQue httpque = (HttpQue)this._que.elementAt(0);
        this._que.removeElementAt(0);
        return httpque;
    }

    public boolean hasQue() {
        if (this._que == null) {
            return false;
        }
        return this._que.size() > 0;
    }

    public void run() {
        while (this._isRun) {
            if (this.hasQue()) {
                HttpQue httpque = this.pop();
                try {
                    byte[] ret = this.requestHttp(httpque.getUrl(), httpque.getPostPrm());
                    httpque.getReciever().httpReceived(ret, httpque.getOption());
                }
                catch (Exception e) {
                    httpque.getReciever().httpErrReceived(e.getMessage(), httpque.getOption());
                }
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._que = null;
    }

    public synchronized byte[] requestHttp(String url) throws IOException, MktIOException {
        return this.requestHttp(url, null);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized byte[] requestHttp(String url, String post) throws IOException, MktIOException {
        void var3_3;
        url = String.valueOf(BaseMain.getPath()) + url;
        byte[] ret = null;
        HttpConnection con = null;
        InputStream in = null;
        try {
            try {
                if (post != null) {
                    con = (HttpConnection)Connector.open((String)url, (int)3, (boolean)true);
                    con.setRequestMethod("POST");
                    con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    OutputStreamWriter osw = new OutputStreamWriter(con.openOutputStream());
                    osw.write(post, 0, post.length());
                    osw.close();
                } else {
                    con = (HttpConnection)Connector.open((String)url, (int)1, (boolean)true);
                    con.setRequestMethod("GET");
                }
                if (con.getResponseCode() != 200) {
                    throw new MktIOException(0, "[requestHttp-status] url=" + url + ", post=" + post);
                }
                in = con.openInputStream();
                ret = ByteUtil.readInputStream(in);
                in.close();
                con.close();
            }
            catch (ConnectionNotFoundException e) {
                throw new MktIOException(1, "[requestHttp-connection] url=" + url + ", post=" + post);
            }
            catch (IOException e) {
                throw new IOException("[requestHttp-io] url=" + url + ", post=" + post);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (IOException iOException) {}
            in = null;
            con = null;
        }
        return var3_3;
    }

    private class HttpQue {
        private HttpReceivedEvent _reciever;
        private String _url;
        private String _post;
        private String[] _option;

        public HttpQue(HttpReceivedEvent receiver, String url, String post, String[] option) {
            this._reciever = receiver;
            this._url = url;
            this._post = post;
            this._option = option;
        }

        public HttpReceivedEvent getReciever() {
            return this._reciever;
        }

        public String getUrl() {
            return this._url;
        }

        public String getPostPrm() {
            return this._post;
        }

        public String[] getOption() {
            return this._option;
        }
    }
}

