/*
 * Decompiled with CFR 0.152.
 */
package mokit.io;

import java.io.IOException;
import javax.microedition.rms.RecordStore;

public class StoreManager {
    public static final int NO_1 = 1;
    public static final int NO_2 = 2;
    public static final int NO_3 = 3;
    private static final int[] _SIZE = new int[]{1000, 1000, 1000};
    private static RecordStore _rs;

    private void openRstore(boolean isInit) throws IOException {
        try {
            _rs = RecordStore.openRecordStore((String)"RSTORE", (boolean)isInit);
        }
        catch (Exception e) {
            _rs = null;
            throw new IOException("[openRstore OPEN\u5931\u6557]");
        }
    }

    private void closeRstore() {
        try {
            if (_rs != null) {
                _rs.closeRecordStore();
            }
        }
        catch (Exception e) {
            _rs = null;
        }
    }

    private void initRstore() throws IOException {
        try {
            try {
                int i;
                this.openRstore(true);
                int rnum = _rs.getNumRecords();
                if (rnum != 0 && rnum != _SIZE.length) {
                    i = 0;
                    while (i < rnum) {
                        _rs.deleteRecord(i);
                        ++i;
                    }
                    rnum = 0;
                }
                if (rnum == 0) {
                    i = 0;
                    while (i < _SIZE.length) {
                        byte[] w = new byte[_SIZE[i]];
                        _rs.addRecord(w, 0, w.length);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(String.valueOf(e.getMessage()) + "[initRstore \u521d\u671f\u5316\u5931\u6557]");
            }
        }
        finally {
            this.closeRstore();
        }
    }

    private void checkSize(int area, int offset, int len) throws IOException {
        this.initRstore();
        if (area >= _SIZE.length) {
            throw new IOException("[checkSize \u7121\u52b9\u306a\u9818\u57df] area=" + area + ", offset=" + offset + ", len=" + len);
        }
        if (offset + len > _SIZE[area]) {
            throw new IOException("[checkSize overflow] area=" + area + ", offset=" + offset + ", len=" + len);
        }
    }

    public void clear(int area) throws IOException {
        this.checkSize(area, 0, 0);
        this.write(new byte[_SIZE[area]], area, 0);
    }

    public void write(byte[] data, int area, int offset) throws IOException, NullPointerException {
        if (data == null) {
            throw new NullPointerException("[write null] area=" + area + ", offset=" + offset);
        }
        this.checkSize(area, offset, data.length);
        try {
            try {
                this.openRstore(true);
                _rs.setRecord(area, data, offset, data.length);
            }
            catch (Exception e) {
                throw new IOException(String.valueOf(e.getMessage()) + "[write] area=" + area + ", offset=" + offset);
            }
        }
        finally {
            this.closeRstore();
        }
    }

    public byte[] read(int area, int offset, int len) throws IOException {
        this.checkSize(area, offset, len);
        byte[] ret = new byte[len];
        try {
            try {
                this.openRstore(false);
                System.arraycopy(_rs.getRecord(area), offset, ret, 0, len);
            }
            catch (Exception e) {
                throw new IOException(String.valueOf(e.getMessage()) + "[read] area=" + area + ", offset=" + offset + ", len=" + len);
            }
        }
        finally {
            this.closeRstore();
        }
        return ret;
    }
}

