/*
 * Decompiled with CFR 0.152.
 */
package mokit.ui;

import com.j_phone.util.GraphicsUtil;
import java.util.Stack;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mokit.ui.MktFont;
import mokit.ui.MktImage;
import mokit.util.StringUtil;

public class G {
    private static int _width = 0;
    private static int _height = 0;
    private static Image _cvs;
    private static Graphics _g;
    private static Graphics _gon;
    private static Graphics _goff;
    private static int[] _lastColor;
    private static final String TAG_BOLD = "b";
    private static final String TAG_ULINE = "u";
    private static final String TAG_COLOR = "c";
    private static final String TAG_BR = "br";
    private static final String TAG_SIZE = "s";
    private static boolean USE_BOLD;
    private static boolean USE_ULINE;
    private static boolean USE_BR;
    private static Stack _color;
    private static Stack _font;

    static {
        USE_BOLD = false;
        USE_ULINE = false;
        USE_BR = false;
        _color = new Stack();
        _font = new Stack();
    }

    public static void setCvs(int width, int height) {
        _width = width;
        _height = height;
        _cvs = Image.createImage((int)_width, (int)_height);
        _goff = _cvs.getGraphics();
    }

    public static int getWidth() {
        return _width;
    }

    public static int getHeight() {
        return _height;
    }

    public static void setGraphics(Graphics g2) {
        _g = _gon = g2;
    }

    public static Graphics getGraphics() {
        return _g;
    }

    public static void lock() {
        _g = _goff;
    }

    public static void unlock(boolean b) {
        if (_g == _goff) {
            _gon.drawImage(_cvs, 0, 0, 20);
        }
        _g = _gon;
    }

    public static void clearRect(int x1, int y1, int width, int height) {
        int[] color = new int[3];
        if (_lastColor != null) {
            color = new int[]{_lastColor[0], _lastColor[1], _lastColor[2]};
        }
        _g.setColor(255, 255, 255);
        _g.fillRect(x1, y1, width, height);
        _g.setColor(color[0], color[1], color[2]);
    }

    public static void clearAll() {
        G.clearRect(0, 0, 1000, 1000);
    }

    public static void drawString(String str, int x, int y) {
        _g.drawString(str, x, y, 68);
    }

    public static void drawBoldString(String str, int x, int y) {
        G.drawString(str, x, y);
        G.drawString(str, x + 1, y);
    }

    public static void drawBorderString(String str, int x, int y, int[] color, int[] bgcolor) {
        G.setColorRGB(bgcolor[0], bgcolor[1], bgcolor[2]);
        G.drawString(str, x - 1, y - 1);
        G.drawString(str, x - 1, y);
        G.drawString(str, x - 1, y + 1);
        G.drawString(str, x, y - 1);
        G.drawString(str, x, y + 1);
        G.drawString(str, x + 1, y - 1);
        G.drawString(str, x + 1, y);
        G.drawString(str, x + 1, y + 1);
        G.setColorRGB(color[0], color[1], color[2]);
        G.drawString(str, x, y);
    }

    public static void fillRect(int x1, int y1, int xl2, int yl2) {
        _g.fillRect(x1, y1, xl2, yl2);
    }

    public static void drawRect(int x1, int y1, int xl2, int yl2) {
        _g.drawRect(x1, y1, xl2, yl2);
    }

    public static void fillAlphaRect(int x1, int y1, int xl2, int yl2) {
        int[] color = G.getLastColor();
        int argb = color[3] << 24 | color[0] << 16 | color[1] << 8 | color[2];
        int size = xl2 * yl2;
        int[] px = new int[size];
        int i = 0;
        while (i < size) {
            px[i] = argb;
            ++i;
        }
        Image img = Image.createRGBImage((int[])px, (int)xl2, (int)yl2, (boolean)true);
        _g.drawImage(img, x1, y1, 20);
    }

    public static void drawLine(int x1, int y1, int x2, int y2) {
        _g.drawLine(x1, y1, x2, y2);
    }

    public static void drawImage(MktImage img, int x, int y) {
        _g.drawImage(img.getImage(), x, y, 20);
    }

    public static void drawScaledImage(MktImage img, int dx, int dy, int ldx, int ldy, int sx, int sy, int lsx, int lsy) {
        GraphicsUtil.drawRegion((Graphics)_g, (Image)img.getImage(), (int)sx, (int)sy, (int)lsx, (int)lsy, (int)0, (int)dx, (int)dy, (int)ldx, (int)ldy, (int)20, (int)0);
    }

    public static void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        _g.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public static void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        _g.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public static int[] getLastColor() {
        if (_lastColor == null) {
            int[] nArray = new int[4];
            nArray[3] = 255;
            return nArray;
        }
        return _lastColor;
    }

    public static void setColorRGB(int c1, int c2, int c3) {
        _g.setColor(c1, c2, c3);
        _lastColor = new int[]{c1, c2, c3, 255};
    }

    public static void setColorRGB(int c1, int c2, int c3, int c4) {
        _g.setColor(c1, c2, c3);
        _lastColor = new int[]{c1, c2, c3, c4};
    }

    public static void drawTagString(String str, int cvsStX, int cvsStY, int cvsEnX, int lineHeight) {
        int x = cvsStX;
        int y = cvsStY;
        int len = str.length();
        int idxSt = 0;
        int tagSt = 0;
        int tagEn = 0;
        String now = "";
        String next = "";
        MktFont.setFont(MktFont.FONT_TINY);
        while (idxSt < len) {
            now = str.substring(idxSt, idxSt + 1);
            int[] fs = MktFont.getFontSize(now);
            int xmgn = fs[0] + 2;
            if (now.equals("<")) {
                next = str.substring(idxSt + 1, idxSt + 2);
                if (next.equals("/")) {
                    tagSt = idxSt + 1;
                    tagEn = str.indexOf(">", tagSt);
                    G.disableTag(str.substring(tagSt + 1, tagEn));
                } else {
                    tagSt = idxSt;
                    tagEn = str.indexOf(">", tagSt);
                    G.enableTag(str.substring(tagSt + 1, tagEn));
                }
                idxSt = tagEn;
            } else {
                if (USE_BR) {
                    x = cvsStX;
                    y += lineHeight;
                    G.disableTag(TAG_BR);
                }
                if (x >= cvsEnX) {
                    x = cvsStX;
                    y += lineHeight;
                }
                G.drawString(now, x, y);
                if (USE_BOLD) {
                    G.drawString(now, x + 1, y);
                }
                if (USE_ULINE) {
                    G.drawLine(x, y, x + xmgn, y);
                }
                x += xmgn;
            }
            ++idxSt;
        }
    }

    private static void enableTag(String tag) {
        String[] elem = StringUtil.split(tag, "=");
        if (elem[0].equals(TAG_BOLD)) {
            USE_BOLD = true;
        } else if (elem[0].equals(TAG_BR)) {
            USE_BR = true;
        } else if (elem[0].equals(TAG_ULINE)) {
            USE_ULINE = true;
        } else if (elem[0].equals(TAG_COLOR)) {
            _color.push(G.getLastColor());
            int[] c = StringUtil.splitInt(elem[1], ",");
            G.setColorRGB(c[0], c[1], c[2]);
        } else if (elem[0].equals(TAG_SIZE)) {
            _font.push(new int[]{MktFont.getFontType()});
            int size = MktFont.FONT_TINY;
            if (elem[1].equals("small")) {
                size = MktFont.FONT_SMALL;
            } else if (elem[1].equals("medium")) {
                size = MktFont.FONT_MEDIUM;
            } else if (elem[1].equals("large")) {
                size = MktFont.FONT_LARGE;
            }
            MktFont.setFont(size);
        }
    }

    private static void disableTag(String tag) {
        if (tag.equals(TAG_BOLD)) {
            USE_BOLD = false;
        } else if (tag.equals(TAG_BR)) {
            USE_BR = false;
        } else if (tag.equals(TAG_ULINE)) {
            USE_ULINE = false;
        } else if (tag.equals(TAG_COLOR)) {
            int[] c = (int[])_color.pop();
            G.setColorRGB(c[0], c[1], c[2]);
        } else if (tag.equals(TAG_SIZE)) {
            int[] f = (int[])_font.pop();
            MktFont.setFont(f[0]);
        }
    }
}

