package mokit.ui;

import java.util.Stack;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

import com.j_phone.util.GraphicsUtil;

import mokit.util.StringUtil;

/**
 * OtBbNAtHgɊ֘A@\񋟂܂B
 * 
 * @author Takuto Nishioka
 */
public class G {

	// ʉTCY
	private static int _width = 0;

	// ʏcTCY
	private static int _height = 0;

	// obt@OpItXN[C[WB
	private static Image _cvs;

	// `ΏGraphic
	private static Graphics _g;

	// ʕ`pGraphic
	private static Graphics _gon;

	// obt@OpGraphic
	private static Graphics _goff;

	/**
	 * ʃTCYZbg܂B
	 * 
	 * @param width
	 *          
	 * @param height
	 *          c
	 */
	public static void setCvs(int width, int height) {

		_width = width;
		_height = height;

		// obt@Op
		_cvs = Image.createImage(_width, _height);
		_goff = _cvs.getGraphics();
	}

	/**
	 * ʂ̕擾܂B
	 * 
	 * @return ʂ̕Ԃ܂B
	 */
	public static int getWidth() {

		return _width;
	}

	/**
	 * ʂ̍擾܂B
	 * 
	 * @return ʂ̍Ԃ܂B
	 */
	public static int getHeight() {

		return _height;
	}

	/**
	 * GraphicsCX^XZbg܂B
	 * 
	 * @param g2
	 *          GraphicsCX^X
	 */
	public static void setGraphics(Graphics g2) {

		_gon = g2;
		_g = _gon;
	}

	/**
	 * GraphicsCX^XԂ܂B
	 * 
	 * @return GraphicsCX^X
	 */
	public static Graphics getGraphics() {

		return _g;
	}

	/**
	 * `foCXɑ΂āA_uobt@O̊Jn錾܂B
	 */
	public static void lock() {

		_g = _goff;
	}

	/**
	 * `foCXɑ΂āA_uobt@ȌI錾܂B<br>
	 * ߖ񂷂ꍇGameCanvaspflushGraphics()𗘗p悢B<br>
	 * A̕łΉ[VΉyB
	 * 
	 * @param b
	 *          IɃtbV邩ǂ
	 */
	public static void unlock(boolean b) {

		if (_g == _goff) {
			_gon.drawImage(_cvs, 0, 0, Graphics.LEFT | Graphics.TOP);
		}
		_g = _gon;
	}

	/**
	 * `̈wiFœhԂ܂B
	 * 
	 * @param x1
	 *          `̍XW
	 * @param y1
	 *          `̍YW
	 * @param width
	 *          `̕
	 * @param height
	 *          `̍
	 */
	public static void clearRect(int x1, int y1, int width, int height) {
		
		int[] color = {0,0,0};
		if(_lastColor != null){
			color = new int[]{_lastColor[0], _lastColor[1], _lastColor[2]};
		}
		_g.setColor(255, 255, 255);
		_g.fillRect(x1, y1, width, height);
		_g.setColor(color[0], color[1], color[2]);
	}

	/**
	 * ʂwiFœhԂ܂B
	 * 
	 */
	public static void clearAll() {

		clearRect(0, 0, 1000, 1000);
	}

	/**
	 * `悵܂B
	 * 
	 * @param str
	 *          `悷镶
	 * @param x
	 *          XW
	 * @param y
	 *          YW
	 */
	public static void drawString(String str, int x, int y) {

		_g.drawString(str, x, y, Graphics.LEFT | Graphics.BASELINE);
	}

	/**
	 * ̕`悵܂B
	 * 
	 * @param str
	 *          `悷镶
	 * @param x
	 *          XW
	 * @param y
	 *          YW
	 */
	public static void drawBoldString(String str, int x, int y) {

		G.drawString(str, x, y);
		G.drawString(str, x+1, y);
	}

	/**
	 * t̕`悵܂B
	 * 
	 * @param str
	 *        `悷镶
	 * @param x
	 *        XW
	 * @param y
	 *        YW
	 * @param color
	 *        F
	 * @param bgcolor
	 *        wiF
	 */
	public static void drawBorderString(String str, int x, int y, int[] color, int[] bgcolor){
		
		G.setColorRGB(bgcolor[0], bgcolor[1], bgcolor[2]);
		G.drawString(str, x-1, y-1);
		G.drawString(str, x-1, y);
		G.drawString(str, x-1, y+1);

		G.drawString(str, x, y-1);
		G.drawString(str, x, y+1);

		G.drawString(str, x+1, y-1);
		G.drawString(str, x+1, y);
		G.drawString(str, x+1, y+1);

		G.setColorRGB(color[0], color[1], color[2]);
		G.drawString(str, x, y);
	}
	
	/**
	 * `̈hԂ܂B
	 * 
	 * @param x1
	 *          `̍XW
	 * @param y1
	 *          `̍YW
	 * @param xl2
	 *          `̕
	 * @param yl2
	 *          `̍
	 */
	public static void fillRect(int x1, int y1, int xl2, int yl2) {

		_g.fillRect(x1, y1, xl2, yl2);
	}

	/**
	 * ``悵܂B
	 * 
	 * @param x1
	 *          `̍XW
	 * @param y1
	 *          `̍YW
	 * @param xl2
	 *          `̕
	 * @param yl2
	 *          `̍
	 */
	public static void drawRect(int x1, int y1, int xl2, int yl2) {

		_g.drawRect(x1, y1, xl2, yl2);
	}
	
	/**
	 * `̈hԂ܂iAt@T|[gjB
	 * 
	 * @param x1
	 *          `̍XW
	 * @param y1
	 *          `̍YW
	 * @param xl2
	 *          `̕
	 * @param yl2
	 *          `̍
	 */
	public static void fillAlphaRect(int x1, int y1, int xl2, int yl2) {
		
		//@ˑ?
		//x쐬摜̓LbV悢
		
		int[] color = G.getLastColor();
		int argb = color[3] << 24 | color[0] << 16 | color[1] << 8 | color[2];
		
		int size = xl2 * yl2;		
		int[] px = new int[size];
		
		for(int i=0; i<size; i++){
			px[i] = argb;
		}
		
		Image img = Image.createRGBImage(px, xl2, yl2, true);
		_g.drawImage(img, x1, y1, Graphics.LEFT | Graphics.TOP);
	}

	/**
	 * `悵܂B
	 * 
	 * @param x1
	 *          ̕`Jn_XW
	 * @param y1
	 *          ̕`Jn_YW
	 * @param x2
	 *          ̕`I_XW
	 * @param y2
	 *          ̕`I_YW
	 */
	public static void drawLine(int x1, int y1, int x2, int y2) {

		_g.drawLine(x1, y1, x2, y2);
	}

	/**
	 * C[W`悵܂B
	 * 
	 * @param img
	 *          `悷C[WIuWFNg
	 * @param x
	 *          XW
	 * @param y
	 *          YW
	 */
	public static void drawImage(MktImage img, int x, int y) {

		_g.drawImage(img.getImage(), x, y, Graphics.LEFT | Graphics.TOP);
	}

	/**
	 * C[WgEkĕ`悵܂B
	 * 
	 * @param img
	 *          `悷C[WIuWFNg
	 * @param dx
	 *          `̋`̍ X W
	 * @param dy
	 *          `̋`̍ Y W
	 * @param ldx
	 *          `̋`̕
	 * @param ldy
	 *          `̋`̍
	 * @param sx
	 *          `挳̋`̍ X W
	 * @param sy
	 *          `挳̋`̍ Y W
	 * @param lsx
	 *          `挳̋`̕
	 * @param lsy
	 *          `挳̋`̍
	 */
	 public static void drawScaledImage(MktImage img, int dx, int dy, int ldx, int ldy, int sx, int sy, int lsx, int lsy) {

		 //TODO MEXA̋@ˑAPIȂ̂ŕʓrƎKv
		 GraphicsUtil.drawRegion(
				 _g, 
				 img.getImage(), 
				 sx, sy, lsx, lsy, 
				 GraphicsUtil.TRANS_NONE,
				 dx, dy, ldx, ldy,
				 Graphics.LEFT | Graphics.TOP,
				 GraphicsUtil. STRETCH_QUALITY_NORMAL
				 );
	}
	 

	/**
	 * ʂ`悵܂B
	 * 
	 * @param x
	 *          ʂ̍XW
	 * @param y
	 *          ʂ̍YW
	 * @param width
	 *          ʂ̕
	 * @param height
	 *          ʂ̍
	 * @param startAngle
	 *          ʂ̎n_̊px
	 * @param arcAngle
	 *          ʂ̎n_̊px
	 */
	public static void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {

		_g.drawArc(x, y, width, height, startAngle, arcAngle);
	}

	/**
	 * ʂhԂ܂B
	 * 
	 * @param x
	 *          ʂ̍XW
	 * @param y
	 *          ʂ̍YW
	 * @param width
	 *          ʂ̕
	 * @param height
	 *          ʂ̍
	 * @param startAngle
	 *          ʂ̎n_̊px
	 * @param arcAngle
	 *          ʂ̎n_̊px
	 */
	public static void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {

		_g.fillArc(x, y, width, height, startAngle, arcAngle);
	}

	// ---------------------------------------------------------------
	// J[֘A
	//	
	// ---------------------------------------------------------------

	// ŌɃZbgꂽJ[
	private static int[] _lastColor;

	/**
	 * ݗLȃJ[擾܂B
	 * 
	 * @return RGB̐lzԂ܂B
	 */
	public static int[] getLastColor() {

		if (_lastColor == null) {
			return new int[] {
					0, 0, 0, 255
			};
		} else {
			return _lastColor;
		}
	}

	/**
	 * J[Zbg܂B
	 * 
	 * @param c1
	 *          R
	 * @param c2
	 *          G
	 * @param c3
	 *          B
	 */
	public static void setColorRGB(int c1, int c2, int c3) {

		_g.setColor(c1, c2, c3);
		_lastColor = new int[] {
				c1, c2, c3, 255
		};
	}

	/**
	 * J[Zbg܂B
	 * 
	 * @param c1
	 *          R
	 * @param c2
	 *          G
	 * @param c3
	 *          B
	 * @param c4
	 *          At@l
	 */
	public static void setColorRGB(int c1, int c2, int c3, int c4) {

		//At@l͐ݒłȂB
		_g.setColor(c1, c2, c3);
		_lastColor = new int[]{c1, c2, c3, c4};
	}
	 

	// ---------------------------------------------------------------
	// ^O`惁\bh
	//	
	// ---------------------------------------------------------------
	// <b>^O
	private static final String TAG_BOLD = "b";
	// <u>^O
	private static final String TAG_ULINE = "u";
	// <c>^O
	private static final String TAG_COLOR = "c";
	// <br>^O
	private static final String TAG_BR = "br";
	// <s>^O
	private static final String TAG_SIZE = "s";

	// <b>Lǂ
	private static boolean USE_BOLD = false;
	// <u>Lǂ
	private static boolean USE_ULINE = false;
	// <br>Lǂ
	private static boolean USE_BR = false;

	// Fޔp
	private static Stack _color = new Stack();
	// tHgTCYޔp
	private static Stack _font = new Stack();

	/**
	 * `ꂽ^O𗘗pĕ𑕏`悵܂B<br>
	 * 
	 *yp\^Oz 
	 * TCYݒ <s=TCY>...</s> itiny, small, medium, large w\j 
	 * Fݒ     <c=R,G,B>...</c> 
	 *            <b>...</b> 
	 * A_[C <u>...</u> 
	 * s           <br>
	 * 
	 * @param str
	 *          ^O܂񂾕
	 * @param cvsStX
	 *          `JnʒuX
	 * @param cvsStY
	 *          `JnʒuY
	 * @param cvsEnX
	 *          `IʒuX
	 * @param lineHeight
	 *          s
	 */
	public static void drawTagString(String str, int cvsStX, int cvsStY, int cvsEnX, int lineHeight) {

		int x = cvsStX;
		int y = cvsStY;

		int len = str.length();
		int idxSt = 0;
		int tagSt = 0;
		int tagEn = 0;

		String now = "";
		String next = "";

		MktFont.setFont(MktFont.FONT_TINY);

		while (idxSt < len) {

			now = str.substring(idxSt, idxSt + 1);
			int[] fs = MktFont.getFontSize(now);
			int xmgn = fs[0] + 2;

			if (now.equals("<")) {
				next = str.substring(idxSt + 1, idxSt + 2);
				// I^O
				if (next.equals("/")) {
					tagSt = idxSt + 1;
					tagEn = str.indexOf(">", tagSt);
					disableTag(str.substring(tagSt + 1, tagEn));
					// Jn^O
				} else {
					tagSt = idxSt;
					tagEn = str.indexOf(">", tagSt);
					enableTag(str.substring(tagSt + 1, tagEn));
				}
				idxSt = tagEn;

			} else {
				// System.out.print(now);
				if (USE_BR) {
					x = cvsStX;
					y += lineHeight;
					// s^O͏IȂ̂
					disableTag(TAG_BR);
				}
				if (x >= cvsEnX) {
					x = cvsStX;
					y += lineHeight;
				}

				drawString(now, x, y);
				if (USE_BOLD) drawString(now, x + 1, y);
				if (USE_ULINE) drawLine(x, y, x + xmgn, y);
				x += xmgn;
			}
			idxSt++;
		}
	}

	/**
	 * w^OLɂ܂B
	 * 
	 * @param tag
	 *          Lɂ^O
	 */
	private static void enableTag(String tag) {

		String[] elem = StringUtil.split(tag, "=");

		if (elem[0].equals(TAG_BOLD)) USE_BOLD = true;
		else if (elem[0].equals(TAG_BR)) USE_BR = true;
		else if (elem[0].equals(TAG_ULINE)) USE_ULINE = true;
		else if (elem[0].equals(TAG_COLOR)) {
			_color.push(getLastColor());
			int[] c = StringUtil.splitInt(elem[1], ",");
			setColorRGB(c[0], c[1], c[2]);
		} else if (elem[0].equals(TAG_SIZE)) {
			_font.push(new int[] {
				MktFont.getFontType()
			});
			int size = MktFont.FONT_TINY;
			if (elem[1].equals("small")) size = MktFont.FONT_SMALL;
			else if (elem[1].equals("medium")) size = MktFont.FONT_MEDIUM;
			else if (elem[1].equals("large")) size = MktFont.FONT_LARGE;
			MktFont.setFont(size);
		}
	}

	/**
	 * w^O𖳌ɂ܂B
	 * 
	 * @param tag
	 *          ɂ^O
	 */
	private static void disableTag(String tag) {

		if (tag.equals(TAG_BOLD)) USE_BOLD = false;
		else if (tag.equals(TAG_BR)) USE_BR = false;
		else if (tag.equals(TAG_ULINE)) USE_ULINE = false;
		else if (tag.equals(TAG_COLOR)) {
			int[] c = (int[]) _color.pop();
			setColorRGB(c[0], c[1], c[2]);
		} else if (tag.equals(TAG_SIZE)) {
			int[] f = (int[]) _font.pop();
			MktFont.setFont(f[0]);
		}
	}

}
