package mokit.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

/**
 * Bytef[^߂̋@\񋟂܂B
 * 
 * @author Takuto Nishioka
 */
public class ByteUtil {

	/**
	 * Stream[hByteɃZbg
	 * 
	 * @param in
	 *        HTTP, ResoruceȂǂStream
	 * @return bytef[^Ԃ܂B
	 * @throws IOException
	 */
	public static byte[] readInputStream(InputStream in) throws IOException {

		ByteArrayOutputStream out = null;
		byte[] w = new byte[10240];
		byte[] data;

		try{
			out = new ByteArrayOutputStream();
			while(true){
				int size = in.read(w);
				if(size <= 0) break;
				out.write(w, 0, size);
			}
			data = out.toByteArray();

		}catch(Exception e){
			data = null;

		}finally{
			try{
				if(out != null) out.close();
			}catch(IOException e){
			}
		}

		if(data == null){
			throw new IOException();
		}

		return data;
	}
	
	/**
	 * 񂩂oCgz擾܂B
	 * 
	 * @param str
	 *        Ώە
	 * @return UTF-8̃oCgzԂ܂B
	 */
	public static byte[] getBytes(String str) {

		byte[] b = null;
		try{
			b = str.getBytes("UTF-8");
		}catch(UnsupportedEncodingException e){
			b = str.getBytes();
		}
		return b;
	}

	/**
	 * oCgz񂩂當𐶐܂B
	 * 
	 * @param data
	 *        oCgz
	 * @return UTF-8̕Ԃ܂B
	 */
	public static String byte2Str(byte[] data) {

		String str = null;
		try{
			str = new String(data, 0, data.length, "UTF-8");
		}catch(UnsupportedEncodingException e){
			str = new String(data);
		}
		return str;
	}
}
